% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_colour_science.R
\name{scale_colour_soil}
\alias{scale_colour_soil}
\alias{scale_color_soil}
\alias{scale_fill_soil}
\alias{scale_edge_colour_soil}
\alias{scale_edge_color_soil}
\alias{scale_edge_fill_soil}
\title{FAO Soil Reference Groups Color Scheme for \pkg{ggplot2} and \pkg{ggraph}}
\usage{
scale_colour_soil(..., lang = "en", aesthetics = "colour")

scale_color_soil(..., lang = "en", aesthetics = "colour")

scale_fill_soil(..., lang = "en", aesthetics = "fill")

scale_edge_colour_soil(..., lang = "en")

scale_edge_color_soil(..., lang = "en")

scale_edge_fill_soil(..., lang = "en")
}
\arguments{
\item{...}{Arguments passed on to \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}}.}

\item{lang}{A \code{\link{character}} string specifying the language for the
color names (see details). It must be one of "\code{en}" (english, the
default), "\code{fr}" (french) or \code{NULL}. If not \code{NULL}, the values will be
matched based on the color names.}

\item{aesthetics}{A \code{\link{character}} string or vector of character
strings listing the name(s) of the aesthetic(s) that this scale works with.}
}
\value{
A \link[ggplot2:discrete_scale]{discrete} scale.
}
\description{
Provides the FAO Soil Reference Groups colour scheme.
}
\details{
Values will be matched based on the soil names.
}
\examples{
library(ggplot2)

soil <- data.frame(
  name = c(
    "Acrisol", "Albeluvisol", "Andosol", "Anthrosol", "Arenosol", "Calcisol",
    "Cambisol", "Chernozem", "Cryosol", "Fluvisol", "Kastanozem", "Gleysol",
    "Gypsisol", "Histosol", "Leptosol", "Luvisol", "Phaeozem", "Planosol",
    "Podzol", "Regosol", "Solonchak", "Solonetz", "Umbrisol", "Vertisol"
  )
)

ggplot2::ggplot(soil, ggplot2::aes(fill = name)) +
  ggplot2::geom_rect(aes(xmin = rep(0, 24), xmax = rep(1, 24),
                         ymin = 1:24, ymax = 1:24+1)) +
  ggplot2::scale_y_reverse() +
  scale_fill_soil(name = "Soil")
}
\references{
Jones, A., Montanarella, L. & Jones, R. (Ed.) (2005). \emph{Soil atlas of
Europe}. Luxembourg: European Commission, Office for Official Publications
of the European Communities. 128 pp. ISBN: 92-894-8120-X.
}
\seealso{
Other themed colour schemes: 
\code{\link{scale_colour_land}()},
\code{\link{scale_colour_stratigraphy}()}

Other qualitative colour schemes: 
\code{\link{scale_colour_land}()},
\code{\link{scale_colour_stratigraphy}()},
\code{\link{scale_edge_colour_okabeito}()},
\code{\link{scale_okabeito_discrete}}
}
\author{
N. Frerebeau
}
\concept{qualitative colour schemes}
\concept{themed colour schemes}
