% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anomalize.R
\name{convert}
\alias{convert}
\title{Simulate Colour-Blindness}
\usage{
convert(x, mode)
}
\arguments{
\item{x}{A palette \code{\link{function}} that when called with a single
integer argument (the number of levels) returns a vector of colours
(see \code{\link{colour}}).}

\item{mode}{A \code{\link{character}} string giving the colour-blind vision
to be used. It must be one of "\code{deuteranopia}", "\code{protanopia}",
"\code{tritanopia}" or "\code{achromatopsia}".
Any unambiguous substring can be given.}
}
\value{
A palette \code{\link{function}} that returns a vector of anomalized
 colours. All the attributes of the initial palette function are inherited,
 with a supplementary attribute "\code{mode}" giving the corresponding
 colour-blind vision.
}
\description{
Simulate Colour-Blindness
}
\examples{
# Trichromat
pal <- colour("bright")
scales::show_col(pal(7))

# Deuteranopia
deu <- convert(pal, mode = "deuteranopia")
scales::show_col(deu(7))

# Protanopia
pro <- convert(pal, mode = "protanopia")
scales::show_col(pro(7))

# Tritanopia
tri <- convert(pal, mode = "tritanopia")
scales::show_col(tri(7))

# Achromatopsia
ach <- convert(pal, mode = "achromatopsia")
scales::show_col(ach(7))
}
\references{
Brettel, H., Viénot, F. and Mollon, J. D. (1997). Computerized Simulation of
 Color Appearance for Dichromats. \emph{Journal of the Optical Society of
 America A}, 14(10), p. 2647-2655.
 DOI: \href{https://doi.org/10.1364/JOSAA.14.002647}{10.1364/JOSAA.14.002647}.

 Tol, P. (2018). \emph{Colour Schemes}. SRON. Technical Note No.
 SRON/EPS/TN/09-002, issue 3.1.
 URL: \url{https://personal.sron.nl/~pault/data/colourschemes.pdf}

 Viénot, F., Brettel, H. and Mollon, J. D. (1999). Digital Video
 Colourmaps for Checking the Legibility of Displays by Dichromats.
 \emph{Color Research & Application}, 24(4), p. 243-52.
 DOI: \href{https://doi.org/10.1002/(SICI)1520-6378(199908)24:4<243::AID-COL5>3.0.CO;2-3}{10.1002/(SICI)1520-6378(199908)24:4<243::AID-COL5>3.0.CO;2-3}.
}
\author{
N. Frerebeau
}
