% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palettes.R
\name{palette_color_continuous}
\alias{palette_color_continuous}
\alias{palette_colour_continuous}
\title{Color Mapping (continuous)}
\usage{
palette_color_continuous(
  colors = NULL,
  domain = NULL,
  midpoint = NULL,
  missing = "#DDDDDD"
)

palette_colour_continuous(
  colors = NULL,
  domain = NULL,
  midpoint = NULL,
  missing = "#DDDDDD"
)
}
\arguments{
\item{colors}{A vector of colors or a \code{\link{function}} that when called with a
single argument (an integer specifying the number of colors) returns a
vector of colors. If \code{NULL} (the default), uses \emph{YlOrRd}.}

\item{domain}{A \code{\link{numeric}} range specifying the possible values that can be
mapped.}

\item{midpoint}{A length-one \code{\link{numeric}} vector specifying the mid-point of
input range.}

\item{missing}{The color to return for \code{NA} values.}
}
\value{
A palette \code{\link{function}} that when called with a single argument
(a \code{\link{numeric}} vector of continuous values) returns a \code{\link{character}} vector
of colors.
}
\description{
Maps continuous values to an interpolated colors gradient.
}
\examples{
## Visualize a simple DEM model
## Distribution of elevation values
elevation <- hist(volcano)

## Where are breaks?
elevation$breaks

## Build palette functions
BuRd <- color("BuRd")
ramp_BuRd <- palette_color_continuous(colors = BuRd(10))

## Plot image
image(volcano, col = ramp_BuRd(elevation$breaks))
legend("topright", legend = elevation$breaks, fill = ramp_BuRd(elevation$breaks))

## Scatter plot
## Build color palette functions
YlOrBr <- color("YlOrBr")
pal_color <- palette_color_continuous(colors = YlOrBr)

## Build symbol palette functions
pal_size <- palette_size_sequential(range = c(1, 3))

## Plot
plot(
  x = iris$Petal.Length,
  y = iris$Sepal.Length,
  pch = 16,
  col = pal_color(iris$Petal.Length),
  cex = pal_size(iris$Petal.Length),
  xlab = "Petal length",
  ylab = "Sepal length",
  panel.first = grid(),
  las = 1
)
}
\seealso{
\code{\link[grDevices:colorRamp]{grDevices::colorRamp()}}

Other palettes: 
\code{\link{palette_color_discrete}()},
\code{\link{palette_color_picker}()},
\code{\link{palette_shape}()},
\code{\link{palette_size}}
}
\concept{palettes}
