% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/keyplayer.R
\name{diffusion}
\alias{diffusion}
\title{Compute the Diffusion Centrality Score in a Network}
\usage{
diffusion(adj.matrix, node, T = ncol(adj.matrix))
}
\arguments{
\item{adj.matrix}{Matrix indicating the adjacency matrix of the network.
It is suggested that the inputted adjacency matrix for the diffusion centrality
be properly transfomred to the probability interpretation.}

\item{node}{Integer indicating the column index of the chosen player
in the adjacenncy matrix. If not specified, scores for all nodes will be reported.}

\item{T}{Integer indicating the maximum number of iterations
of communication process. In the first iteration, the adjacency matrix
is as the input. In the nth iteration, the adjacency matrix becomes
the input adjacency matrix to the power of n. By default, T is the network size.}
}
\value{
A vector indicating the defusion centrality score(s) of
the chosen player(s).
}
\description{
\code{diffusion} measures player's ability to disseminate information when
the process is modeled random. The adjacency matrix should carry this randomness,
where edge value p_{ij} represents the probability that information is passed from
i to j.
}
\details{
The diffusion centrality is developed by Banerjee et.al. (2013),
where it finds that this fairly general measure approximates the
empirical result of word-of-mouth diffusion well.
It is general because it can represents (or approximates) the degree centrality,
eigenvector centrality, and Katz-Bonacich centrality, in different settings.
See the Banerjee et.al. (2014) for proofs.
}
\examples{
# Create a 5x5 weighted and directed adjacency matrix, where edge values
# represent the strength of tie
W <- matrix(
  c(0,1,3,0,0,
    0,0,0,4,0,
    1,1,0,2,0,
    0,0,0,0,3,
    0,2,0,0,0),
    nrow=5, ncol=5, byrow = TRUE)

# Transform the edge value to probability interpretaion
P <- W *0.2

# List the diffusion centrality score for every node
diffusion(P, T = 2)
}
\author{
Weihua An \email{weihuaan@indiana.edu}; Yu-Hsin Liu \email{yuhsliu@indiana.edu}
}
\references{
Banerjee, A., A. Chandrasekhar, E. Duflo, and M. Jackson (2013):
"Diffusion of Microfinance," \emph{Science}, Vol. 341. p.363\cr

Banerjee, A., A. Chandrasekhar, E. Duflo, and M. Jackson (2014):
"Gossip: Identifying Central Individuals in a Social Network,"
Working paper\cr
}
\seealso{
\code{\link{kpcent}};
\code{\link{kpset}}
}

