% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/keyplayer.R
\name{contract}
\alias{contract}
\title{Group the Chosen Players in a Network}
\usage{
contract(adj.matrix, nodes, method = c("min", "max", "union", "add"))
}
\arguments{
\item{adj.matrix}{Matrix indicating the adjacency matrix of the network.}

\item{nodes}{Integer indicating the column index of the chosen player
in the adjacenncy matrix. Input \code{c(index1,index2,...)} for multiple players}

\item{method}{Indication of which grouping criterion should be used.
\code{method="min"} indicates the "minimum" criterion (edge values as distances).
\code{method="max"} indicates the "maximum" criterion (edge values as non-cummulative strengths).
\code{method="add"} indicates the "addition" criterion (edge values as cummulative strengths).
\code{method="union"} indicates the "union" criterion (edge values as probability).
The default uses the "minimum" criterion as the distances interpretation is standard in \pkg{sna}.}
}
\value{
A new adjacency matrix after contracting the chosen nodes (named
\code{set}).
}
\description{
\code{contract} is a fundmental tool for analyzing the group-level centrality.
It contracts the chosen nodes into one following a specified rule, and thus
the node-level method can be applied. There are four grouping criteria
in the \code{contract} function: \code{minimum}, \code{maximum}, \code{union},
and \code{addition},
each of them responses to a specific interpretation of the edge values
of the adjacency matrix. See details.
}
\details{
When the edge values are interpreted as distances, the contracting
follows a "minimum" rule that the distance (edge value) between an objective
and the contracting set is the minimun distance of each individual node in
the set. For example, suppose A to C has distance 2 and B to C has distance 1,
then the distance between C and the merged set AB is 1.

When the edge values are interpreted as accumulative strength, the contracting follows
an "addition" rule that the strength (edge value) of tie between an objective
node and the contracting set is simply the summation of the edge value of
each node in the set. In the above example, when the strength interpretation
is used, the strangth of tie between C and the merged AB is 1+2=3. If the strength
is not accumulative, then the "maximum" rule should be applied.

When the edge values are interpreted as probability, the contracting follows
an "union" rule that the link to the set can be formed when at least one of
the nodes in the set is connected. The rule assumes that the link to each
node in the set is independent to each other and thus computes the probability
using 1 minus the product of the probability of not being connected for each
node. For example, suppose A has probability 0.2 to reach C and B has probability
0.5 to reach C, then C can be reached from merged AB with probability 1-(1-0.2)*(1-0.5)=0.6.
}
\author{
Weihua An \email{weihuaan@indiana.edu}; Yu-Hsin Liu \email{yuhsliu@indiana.edu}
}
\references{
Butts, Carter T. (2014). sna: Tools for Social Network Analysis. R package
version 2.3-2. \url{http://CRAN.R-project.org/package=sna}\cr
}
\keyword{internal}

