% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_collapse.R
\name{step_collapse}
\alias{step_collapse}
\title{Collapse Predictors into a single list-column}
\usage{
step_collapse(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  columns = NULL,
  new_col = "predictor_matrix",
  skip = FALSE,
  id = recipes::rand_id("collapse")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of
operations for this recipe.}

\item{...}{One or more selector functions to choose which variables are
affected by the step. See \verb{[selections()]} for more details. For the \code{tidy}
method, these are not currently used.}

\item{role}{For model terms created by this step, what analysis role should
they be assigned?. By default, the new columns are used as predictors.}

\item{trained}{A logical to indicate if the quantities for preprocessing
have been estimated.}

\item{columns}{A character string of the selected variable names. This is
\code{NULL} until the step is trained by \verb{[prep.recipe()]}.}

\item{new_col}{A character string for the name of the new list-column. The
default is "predictor_matrix".}

\item{skip}{A logical. Should the step be skipped when the recipe is
baked by \verb{[bake.recipe()]}? While all operations are baked when \code{prep} is run,
skipping when \code{bake} is run may be other times when it is desirable to
skip a processing step.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of existing steps (if any). For the \code{tidy} method, a tibble with
columns \code{terms} which is the columns that are affected and \code{value} which is
the type of collapse.
}
\description{
\code{step_collapse()} creates a a \emph{specification} of a recipe step that will
convert a group of predictors into a single list-column. This is useful
for custom models that need the predictors in a different format.
}
\examples{
library(recipes)

# 2 predictors
dat <- data.frame(
  x1 = 1:10,
  x2 = 11:20,
  y = 1:10
)

rec <- recipe(y ~ ., data = dat) \%>\%
  step_collapse(x1, x2, new_col = "pred") \%>\%
  prep()

bake(rec, new_data = NULL)
}
