% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{pad_sequences}
\alias{pad_sequences}
\title{Pad a linear sequence for an RNN input}
\usage{
pad_sequences(sequences, maxlen = NULL, dtype = "int32", padding = "pre",
  truncating = "pre", value = 0)
}
\arguments{
\item{sequences}{vector of lists of int or float.}

\item{maxlen}{None or int. Maximum sequence length, longer sequences
are truncated and shorter sequences are padded with
zeros at the end.}

\item{dtype}{datatype of the Numpy array returned.}

\item{padding}{'pre' or 'post', pad either before or after each
sequence.}

\item{truncating}{'pre' or 'post', remove values from sequences larger
than maxlen either in the beginning or in the end of
the sequence}

\item{value}{float, value to pad the sequences to the desired value.}
}
\description{
Transform a list of num_samples sequences (lists of scalars) into a 2D
Numpy array of shape  (num_samples, num_timesteps). num_timesteps is
either the maxlen argument if provided, or the length of the longest
sequence otherwise. Sequences that are shorter than num_timesteps are
padded with value at the end. Sequences longer than num_timesteps are
truncated so that it fits the desired length. Position where padding or
truncation happens is determined by padding or truncating, respectively.
}
\references{
Chollet, Francois. 2015. \href{https://keras.io/}{Keras: Deep Learning library for Theano and TensorFlow}.
}
\seealso{
Other preprocessing: \code{\link{Tokenizer}},
  \code{\link{expand_dims}}, \code{\link{img_to_array}},
  \code{\link{load_img}}, \code{\link{one_hot}},
  \code{\link{text_to_word_sequence}}
}
\author{
Taylor B. Arnold, \email{taylor.arnold@acm.org}
}
