% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-normalization.R
\name{layer_batch_normalization}
\alias{layer_batch_normalization}
\title{Layer that normalizes its inputs.}
\usage{
layer_batch_normalization(
  object,
  axis = -1L,
  momentum = 0.99,
  epsilon = 0.001,
  center = TRUE,
  scale = TRUE,
  beta_initializer = "zeros",
  gamma_initializer = "ones",
  moving_mean_initializer = "zeros",
  moving_variance_initializer = "ones",
  beta_regularizer = NULL,
  gamma_regularizer = NULL,
  beta_constraint = NULL,
  gamma_constraint = NULL,
  synchronized = FALSE,
  ...
)
}
\arguments{
\item{object}{Object to compose the layer with. A tensor, array, or sequential model.}

\item{axis}{Integer, the axis that should be normalized
(typically the features axis). For instance, after a \code{Conv2D} layer
with \code{data_format = "channels_first"}, use \code{axis = 2}.}

\item{momentum}{Momentum for the moving average.}

\item{epsilon}{Small float added to variance to avoid dividing by zero.}

\item{center}{If \code{TRUE}, add offset of \code{beta} to normalized tensor.
If \code{FALSE}, \code{beta} is ignored.}

\item{scale}{If \code{TRUE}, multiply by \code{gamma}. If \code{FALSE}, \code{gamma} is not used.
When the next layer is linear this can be disabled
since the scaling will be done by the next layer.}

\item{beta_initializer}{Initializer for the beta weight.}

\item{gamma_initializer}{Initializer for the gamma weight.}

\item{moving_mean_initializer}{Initializer for the moving mean.}

\item{moving_variance_initializer}{Initializer for the moving variance.}

\item{beta_regularizer}{Optional regularizer for the beta weight.}

\item{gamma_regularizer}{Optional regularizer for the gamma weight.}

\item{beta_constraint}{Optional constraint for the beta weight.}

\item{gamma_constraint}{Optional constraint for the gamma weight.}

\item{synchronized}{Only applicable with the TensorFlow backend.
If \code{TRUE}, synchronizes the global batch statistics (mean and
variance) for the layer across all devices at each training step
in a distributed training strategy.
If \code{FALSE}, each replica uses its own local batch statistics.}

\item{...}{Base layer keyword arguments (e.g. \code{name} and \code{dtype}).}
}
\value{
The return value depends on the value provided for the first argument.
If  \code{object} is:
\itemize{
\item a \code{keras_model_sequential()}, then the layer is added to the sequential model
(which is modified in place). To enable piping, the sequential model is also
returned, invisibly.
\item a \code{keras_input()}, then the output tensor from calling \code{layer(input)} is returned.
\item \code{NULL} or missing, then a \code{Layer} instance is returned.
}
}
\description{
Batch normalization applies a transformation that maintains the mean output
close to 0 and the output standard deviation close to 1.

Importantly, batch normalization works differently during training and
during inference.

\strong{During training} (i.e. when using \code{fit()} or when calling the layer/model
with the argument \code{training = TRUE}), the layer normalizes its output using
the mean and standard deviation of the current batch of inputs. That is to
say, for each channel being normalized, the layer returns
\code{gamma * (batch - mean(batch)) / sqrt(var(batch) + epsilon) + beta}, where:
\itemize{
\item \code{epsilon} is small constant (configurable as part of the constructor
arguments)
\item \code{gamma} is a learned scaling factor (initialized as 1), which
can be disabled by passing \code{scale = FALSE} to the constructor.
\item \code{beta} is a learned offset factor (initialized as 0), which
can be disabled by passing \code{center = FALSE} to the constructor.
}

\strong{During inference} (i.e. when using \code{evaluate()} or \code{predict()} or when
calling the layer/model with the argument \code{training = FALSE} (which is the
default), the layer normalizes its output using a moving average of the
mean and standard deviation of the batches it has seen during training. That
is to say, it returns
\code{gamma * (batch - self$moving_mean) / sqrt(self$moving_var+epsilon) + beta}.

\code{self$moving_mean} and \code{self$moving_var} are non-trainable variables that
are updated each time the layer in called in training mode, as such:
\itemize{
\item \code{moving_mean = moving_mean * momentum + mean(batch) * (1 - momentum)}
\item \code{moving_var = moving_var * momentum + var(batch) * (1 - momentum)}
}

As such, the layer will only normalize its inputs during inference
\emph{after having been trained on data that has similar statistics as the
inference data}.

\strong{About setting \code{layer$trainable <- FALSE} on a \code{BatchNormalization} layer:}

The meaning of setting \code{layer$trainable <- FALSE} is to freeze the layer,
i.e. its internal state will not change during training:
its trainable weights will not be updated
during \code{fit()} or \code{train_on_batch()}, and its state updates will not be run.

Usually, this does not necessarily mean that the layer is run in inference
mode (which is normally controlled by the \code{training} argument that can
be passed when calling a layer). "Frozen state" and "inference mode"
are two separate concepts.

However, in the case of the \code{BatchNormalization} layer, \strong{setting
\code{trainable <- FALSE} on the layer means that the layer will be
subsequently run in inference mode} (meaning that it will use
the moving mean and the moving variance to normalize the current batch,
rather than using the mean and variance of the current batch).

Note that:
\itemize{
\item Setting \code{trainable} on an model containing other layers will recursively
set the \code{trainable} value of all inner layers.
\item If the value of the \code{trainable} attribute is changed after calling
\code{compile()} on a model, the new value doesn't take effect for this model
until \code{compile()} is called again.
}
}
\section{Call Arguments}{
\itemize{
\item \code{inputs}: Input tensor (of any rank).
\item \code{training}: R boolean indicating whether the layer should behave in
training mode or in inference mode.
\itemize{
\item \code{training = TRUE}: The layer will normalize its inputs using
the mean and variance of the current batch of inputs.
\item \code{training = FALSE}: The layer will normalize its inputs using
the mean and variance of its moving statistics, learned during
training.
}
\item \code{mask}: Binary tensor of shape broadcastable to \code{inputs} tensor, with
\code{TRUE} values indicating the positions for which mean and variance
should be computed. Masked elements of the current inputs are not
taken into account for mean and variance computation during
training. Any prior unmasked element values will be taken into
account until their momentum expires.
}
}

\section{Reference}{
\itemize{
\item \href{https://arxiv.org/abs/1502.03167}{Ioffe and Szegedy, 2015}.
}
}

\seealso{
\itemize{
\item \url{https://keras.io/api/layers/normalization_layers/batch_normalization#batchnormalization-class}
}

Other normalization layers: \cr
\code{\link{layer_group_normalization}()} \cr
\code{\link{layer_layer_normalization}()} \cr
\code{\link{layer_spectral_normalization}()} \cr
\code{\link{layer_unit_normalization}()} \cr

Other layers: \cr
\code{\link{Layer}()} \cr
\code{\link{layer_activation}()} \cr
\code{\link{layer_activation_elu}()} \cr
\code{\link{layer_activation_leaky_relu}()} \cr
\code{\link{layer_activation_parametric_relu}()} \cr
\code{\link{layer_activation_relu}()} \cr
\code{\link{layer_activation_softmax}()} \cr
\code{\link{layer_activity_regularization}()} \cr
\code{\link{layer_add}()} \cr
\code{\link{layer_additive_attention}()} \cr
\code{\link{layer_alpha_dropout}()} \cr
\code{\link{layer_attention}()} \cr
\code{\link{layer_auto_contrast}()} \cr
\code{\link{layer_average}()} \cr
\code{\link{layer_average_pooling_1d}()} \cr
\code{\link{layer_average_pooling_2d}()} \cr
\code{\link{layer_average_pooling_3d}()} \cr
\code{\link{layer_bidirectional}()} \cr
\code{\link{layer_category_encoding}()} \cr
\code{\link{layer_center_crop}()} \cr
\code{\link{layer_concatenate}()} \cr
\code{\link{layer_conv_1d}()} \cr
\code{\link{layer_conv_1d_transpose}()} \cr
\code{\link{layer_conv_2d}()} \cr
\code{\link{layer_conv_2d_transpose}()} \cr
\code{\link{layer_conv_3d}()} \cr
\code{\link{layer_conv_3d_transpose}()} \cr
\code{\link{layer_conv_lstm_1d}()} \cr
\code{\link{layer_conv_lstm_2d}()} \cr
\code{\link{layer_conv_lstm_3d}()} \cr
\code{\link{layer_cropping_1d}()} \cr
\code{\link{layer_cropping_2d}()} \cr
\code{\link{layer_cropping_3d}()} \cr
\code{\link{layer_dense}()} \cr
\code{\link{layer_depthwise_conv_1d}()} \cr
\code{\link{layer_depthwise_conv_2d}()} \cr
\code{\link{layer_discretization}()} \cr
\code{\link{layer_dot}()} \cr
\code{\link{layer_dropout}()} \cr
\code{\link{layer_einsum_dense}()} \cr
\code{\link{layer_embedding}()} \cr
\code{\link{layer_equalization}()} \cr
\code{\link{layer_feature_space}()} \cr
\code{\link{layer_flatten}()} \cr
\code{\link{layer_flax_module_wrapper}()} \cr
\code{\link{layer_gaussian_dropout}()} \cr
\code{\link{layer_gaussian_noise}()} \cr
\code{\link{layer_global_average_pooling_1d}()} \cr
\code{\link{layer_global_average_pooling_2d}()} \cr
\code{\link{layer_global_average_pooling_3d}()} \cr
\code{\link{layer_global_max_pooling_1d}()} \cr
\code{\link{layer_global_max_pooling_2d}()} \cr
\code{\link{layer_global_max_pooling_3d}()} \cr
\code{\link{layer_group_normalization}()} \cr
\code{\link{layer_group_query_attention}()} \cr
\code{\link{layer_gru}()} \cr
\code{\link{layer_hashed_crossing}()} \cr
\code{\link{layer_hashing}()} \cr
\code{\link{layer_identity}()} \cr
\code{\link{layer_integer_lookup}()} \cr
\code{\link{layer_jax_model_wrapper}()} \cr
\code{\link{layer_lambda}()} \cr
\code{\link{layer_layer_normalization}()} \cr
\code{\link{layer_lstm}()} \cr
\code{\link{layer_masking}()} \cr
\code{\link{layer_max_num_bounding_boxes}()} \cr
\code{\link{layer_max_pooling_1d}()} \cr
\code{\link{layer_max_pooling_2d}()} \cr
\code{\link{layer_max_pooling_3d}()} \cr
\code{\link{layer_maximum}()} \cr
\code{\link{layer_mel_spectrogram}()} \cr
\code{\link{layer_minimum}()} \cr
\code{\link{layer_mix_up}()} \cr
\code{\link{layer_multi_head_attention}()} \cr
\code{\link{layer_multiply}()} \cr
\code{\link{layer_normalization}()} \cr
\code{\link{layer_permute}()} \cr
\code{\link{layer_rand_augment}()} \cr
\code{\link{layer_random_brightness}()} \cr
\code{\link{layer_random_color_degeneration}()} \cr
\code{\link{layer_random_color_jitter}()} \cr
\code{\link{layer_random_contrast}()} \cr
\code{\link{layer_random_crop}()} \cr
\code{\link{layer_random_flip}()} \cr
\code{\link{layer_random_grayscale}()} \cr
\code{\link{layer_random_hue}()} \cr
\code{\link{layer_random_posterization}()} \cr
\code{\link{layer_random_rotation}()} \cr
\code{\link{layer_random_saturation}()} \cr
\code{\link{layer_random_sharpness}()} \cr
\code{\link{layer_random_shear}()} \cr
\code{\link{layer_random_translation}()} \cr
\code{\link{layer_random_zoom}()} \cr
\code{\link{layer_repeat_vector}()} \cr
\code{\link{layer_rescaling}()} \cr
\code{\link{layer_reshape}()} \cr
\code{\link{layer_resizing}()} \cr
\code{\link{layer_rnn}()} \cr
\code{\link{layer_separable_conv_1d}()} \cr
\code{\link{layer_separable_conv_2d}()} \cr
\code{\link{layer_simple_rnn}()} \cr
\code{\link{layer_solarization}()} \cr
\code{\link{layer_spatial_dropout_1d}()} \cr
\code{\link{layer_spatial_dropout_2d}()} \cr
\code{\link{layer_spatial_dropout_3d}()} \cr
\code{\link{layer_spectral_normalization}()} \cr
\code{\link{layer_stft_spectrogram}()} \cr
\code{\link{layer_string_lookup}()} \cr
\code{\link{layer_subtract}()} \cr
\code{\link{layer_text_vectorization}()} \cr
\code{\link{layer_tfsm}()} \cr
\code{\link{layer_time_distributed}()} \cr
\code{\link{layer_torch_module_wrapper}()} \cr
\code{\link{layer_unit_normalization}()} \cr
\code{\link{layer_upsampling_1d}()} \cr
\code{\link{layer_upsampling_2d}()} \cr
\code{\link{layer_upsampling_3d}()} \cr
\code{\link{layer_zero_padding_1d}()} \cr
\code{\link{layer_zero_padding_2d}()} \cr
\code{\link{layer_zero_padding_3d}()} \cr
\code{\link{rnn_cell_gru}()} \cr
\code{\link{rnn_cell_lstm}()} \cr
\code{\link{rnn_cell_simple}()} \cr
\code{\link{rnn_cells_stack}()} \cr
}
\concept{layers}
\concept{normalization layers}
