% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer-methods.R
\name{get_weights}
\alias{get_weights}
\alias{set_weights}
\title{Layer/Model weights as R arrays}
\usage{
get_weights(object, trainable = NA)

set_weights(object, weights)
}
\arguments{
\item{object}{Layer or model object}

\item{trainable}{if \code{NA} (the default), all weights are returned. If \code{TRUE},
only weights of trainable variables are returned. If \code{FALSE}, only weights
of non-trainable variables are returned.}

\item{weights}{Weights as R array}
}
\value{
A list of R arrays.
}
\description{
Layer/Model weights as R arrays
}
\note{
You can access the Layer/Model as \code{KerasVariables} (which are also
backend-native tensors like \code{tf.Variable}) at \code{object$weights},
\code{object$trainable_weights}, or \code{object$non_trainable_weights}
}
\seealso{
Other layer methods: \cr
\code{\link{count_params}()} \cr
\code{\link{get_config}()} \cr
\code{\link{quantize_weights}()} \cr
\code{\link{reset_state}()} \cr
}
\concept{layer methods}
\concept{model persistence}
