% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing-image.R
\name{image_smart_resize}
\alias{image_smart_resize}
\title{Resize images to a target size without aspect ratio distortion.}
\usage{
image_smart_resize(
  x,
  size,
  interpolation = "bilinear",
  data_format = "channels_last",
  backend_module = NULL
)
}
\arguments{
\item{x}{Input image or batch of images (as a tensor or array).
Must be in format \verb{(height, width, channels)}
or \verb{(batch_size, height, width, channels)}.}

\item{size}{Tuple of \verb{(height, width)} integer. Target size.}

\item{interpolation}{String, interpolation to use for resizing.
Supports \code{"bilinear"}, \code{"nearest"}, \code{"bicubic"},
\code{"lanczos3"}, \code{"lanczos5"}.
Defaults to \code{'bilinear'}.}

\item{data_format}{\code{"channels_last"} or \code{"channels_first"}.}

\item{backend_module}{Backend module to use (if different from the default
backend).}
}
\value{
Array with shape \verb{(size[1], size[2], channels)}.
If the input image was an array, the output is an array,
and if it was a backend-native tensor,
the output is a backend-native tensor.
}
\description{
Image datasets typically yield images that have each a different
size. However, these images need to be batched before they can be
processed by Keras layers. To be batched, images need to share the same
height and width.

You could simply do, in TF (or JAX equivalent):

\if{html}{\out{<div class="sourceCode r">}}\preformatted{size <- c(200, 200)
ds <- ds$map(\\(img) tf$image$resize(img, size))
}\if{html}{\out{</div>}}

However, if you do this, you distort the aspect ratio of your images, since
in general they do not all have the same aspect ratio as \code{size}. This is
fine in many cases, but not always (e.g. for image generation models
this can be a problem).

Note that passing the argument \code{preserve_aspect_ratio = TRUE} to \code{tf$image$resize()}
will preserve the aspect ratio, but at the cost of no longer respecting the
provided target size.

This calls for:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{size <- c(200, 200)
ds <- ds$map(\\(img) image_smart_resize(img, size))
}\if{html}{\out{</div>}}

Your output images will actually be \verb{(200, 200)}, and will not be distorted.
Instead, the parts of the image that do not fit within the target size
get cropped out.

The resizing process is:
\enumerate{
\item Take the largest centered crop of the image that has the same aspect
ratio as the target size. For instance, if \code{size = c(200, 200)} and the input
image has size \verb{(340, 500)}, we take a crop of \verb{(340, 340)} centered along
the width.
\item Resize the cropped image to the target size. In the example above,
we resize the \verb{(340, 340)} crop to \verb{(200, 200)}.
}
}
\seealso{
Other image utils: \cr
\code{\link{image_array_save}()} \cr
\code{\link{image_from_array}()} \cr
\code{\link{image_load}()} \cr
\code{\link{image_to_array}()} \cr
\code{\link{op_image_affine_transform}()} \cr
\code{\link{op_image_crop}()} \cr
\code{\link{op_image_extract_patches}()} \cr
\code{\link{op_image_hsv_to_rgb}()} \cr
\code{\link{op_image_map_coordinates}()} \cr
\code{\link{op_image_pad}()} \cr
\code{\link{op_image_resize}()} \cr
\code{\link{op_image_rgb_to_grayscale}()} \cr
\code{\link{op_image_rgb_to_hsv}()} \cr

Other utils: \cr
\code{\link{audio_dataset_from_directory}()} \cr
\code{\link{clear_session}()} \cr
\code{\link{config_disable_interactive_logging}()} \cr
\code{\link{config_disable_traceback_filtering}()} \cr
\code{\link{config_enable_interactive_logging}()} \cr
\code{\link{config_enable_traceback_filtering}()} \cr
\code{\link{config_is_interactive_logging_enabled}()} \cr
\code{\link{config_is_traceback_filtering_enabled}()} \cr
\code{\link{get_file}()} \cr
\code{\link{get_source_inputs}()} \cr
\code{\link{image_array_save}()} \cr
\code{\link{image_dataset_from_directory}()} \cr
\code{\link{image_from_array}()} \cr
\code{\link{image_load}()} \cr
\code{\link{image_to_array}()} \cr
\code{\link{layer_feature_space}()} \cr
\code{\link{normalize}()} \cr
\code{\link{pad_sequences}()} \cr
\code{\link{set_random_seed}()} \cr
\code{\link{split_dataset}()} \cr
\code{\link{text_dataset_from_directory}()} \cr
\code{\link{timeseries_dataset_from_array}()} \cr
\code{\link{to_categorical}()} \cr
\code{\link{zip_lists}()} \cr

Other preprocessing: \cr
\code{\link{image_dataset_from_directory}()} \cr
\code{\link{text_dataset_from_directory}()} \cr
\code{\link{timeseries_dataset_from_array}()} \cr
}
\concept{image utils}
\concept{preprocessing}
\concept{utils}
