% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initializers.R
\name{initializer_glorot_normal}
\alias{initializer_glorot_normal}
\title{The Glorot normal initializer, also called Xavier normal initializer.}
\usage{
initializer_glorot_normal(seed = NULL)
}
\arguments{
\item{seed}{An integer or instance of
\code{random_seed_generator()}.
Used to make the behavior of the initializer
deterministic. Note that an initializer seeded with an integer
or \code{NULL} (unseeded) will produce the same random values
across multiple calls. To get different random values
across multiple calls, use as seed an instance
of \code{random_seed_generator()}.}
}
\value{
An \code{Initializer} instance that can be passed to layer or variable
constructors, or called directly with a \code{shape} to return a Tensor.
}
\description{
Draws samples from a truncated normal distribution centered on 0 with
\code{stddev = sqrt(2 / (fan_in + fan_out))} where \code{fan_in} is the number of
input units in the weight tensor and \code{fan_out} is the number of output units
in the weight tensor.
}
\section{Examples}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Standalone usage:
initializer <- initializer_glorot_normal()
values <- initializer(shape = c(2, 2))
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Usage in a Keras layer:
initializer <- initializer_glorot_normal()
layer <- layer_dense(units = 3, kernel_initializer = initializer)
}\if{html}{\out{</div>}}
}

\section{Reference}{
\itemize{
\item \href{https://proceedings.mlr.press/v9/glorot10a.html}{Glorot et al., 2010}
}
}

\seealso{
\itemize{
\item \url{https://keras.io/api/layers/initializers#glorotnormal-class}
}

Other random initializers: \cr
\code{\link{initializer_glorot_uniform}()} \cr
\code{\link{initializer_he_normal}()} \cr
\code{\link{initializer_he_uniform}()} \cr
\code{\link{initializer_lecun_normal}()} \cr
\code{\link{initializer_lecun_uniform}()} \cr
\code{\link{initializer_orthogonal}()} \cr
\code{\link{initializer_random_normal}()} \cr
\code{\link{initializer_random_uniform}()} \cr
\code{\link{initializer_truncated_normal}()} \cr
\code{\link{initializer_variance_scaling}()} \cr

Other initializers: \cr
\code{\link{initializer_constant}()} \cr
\code{\link{initializer_glorot_uniform}()} \cr
\code{\link{initializer_he_normal}()} \cr
\code{\link{initializer_he_uniform}()} \cr
\code{\link{initializer_identity}()} \cr
\code{\link{initializer_lecun_normal}()} \cr
\code{\link{initializer_lecun_uniform}()} \cr
\code{\link{initializer_ones}()} \cr
\code{\link{initializer_orthogonal}()} \cr
\code{\link{initializer_random_normal}()} \cr
\code{\link{initializer_random_uniform}()} \cr
\code{\link{initializer_truncated_normal}()} \cr
\code{\link{initializer_variance_scaling}()} \cr
\code{\link{initializer_zeros}()} \cr
}
\concept{initializers}
\concept{random initializers}
