% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applications.R
\name{application_densenet121}
\alias{application_densenet121}
\title{Instantiates the Densenet121 architecture.}
\usage{
application_densenet121(
  include_top = TRUE,
  weights = "imagenet",
  input_tensor = NULL,
  input_shape = NULL,
  pooling = NULL,
  classes = 1000L,
  classifier_activation = "softmax",
  name = "densenet121"
)
}
\arguments{
\item{include_top}{whether to include the fully-connected
layer at the top of the network.}

\item{weights}{one of \code{NULL} (random initialization),
\code{"imagenet"} (pre-training on ImageNet),
or the path to the weights file to be loaded.}

\item{input_tensor}{optional Keras tensor
(i.e. output of \code{keras_input()})
to use as image input for the model.}

\item{input_shape}{optional shape tuple, only to be specified
if \code{include_top} is \code{FALSE} (otherwise the input shape
has to be \verb{(224, 224, 3)} (with \code{'channels_last'} data format)
or \verb{(3, 224, 224)} (with \code{'channels_first'} data format).
It should have exactly 3 inputs channels,
and width and height should be no smaller than 32.
E.g. \verb{(200, 200, 3)} would be one valid value.}

\item{pooling}{Optional pooling mode for feature extraction
when \code{include_top} is \code{FALSE}.
\itemize{
\item \code{NULL} means that the output of the model will be
the 4D tensor output of the
last convolutional block.
\item \code{avg} means that global average pooling
will be applied to the output of the
last convolutional block, and thus
the output of the model will be a 2D tensor.
\item \code{max} means that global max pooling will
be applied.
}}

\item{classes}{optional number of classes to classify images
into, only to be specified if \code{include_top} is \code{TRUE}, and
if no \code{weights} argument is specified.}

\item{classifier_activation}{A \code{str} or callable.
The activation function to use
on the "top" layer. Ignored unless \code{include_top=TRUE}. Set
\code{classifier_activation=NULL} to return the logits
of the "top" layer. When loading pretrained weights,
\code{classifier_activation} can only be \code{NULL} or \code{"softmax"}.}

\item{name}{The name of the model (string).}
}
\value{
A Keras model instance.
}
\description{
Instantiates the Densenet121 architecture.
}
\section{Reference}{
\itemize{
\item \href{https://arxiv.org/abs/1608.06993}{Densely Connected Convolutional Networks} (CVPR 2017)
}

Optionally loads weights pre-trained on ImageNet.
Note that the data format convention used by the model is
the one specified in your Keras config at \verb{~/.keras/keras.json}.
}

\section{Note}{
Each Keras Application expects a specific kind of input preprocessing.
For DenseNet, call \code{\link[=application_preprocess_inputs]{application_preprocess_inputs()}}
on your inputs before passing them to the model.
}

\seealso{
\itemize{
\item \url{https://keras.io/api/applications/densenet#densenet121-function}
}
}
