% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-persistence.R
\name{serialize_keras_object}
\alias{serialize_keras_object}
\title{Retrieve the full config by serializing the Keras object.}
\usage{
serialize_keras_object(obj)
}
\arguments{
\item{obj}{the Keras object to serialize.}
}
\value{
A named list that represents the object config.
The config is expected to contain simple types only, and
can be saved as json.
The object can be
deserialized from the config via \code{deserialize_keras_object()}.
}
\description{
\code{serialize_keras_object()} serializes a Keras object to a named list
that represents the object, and is a reciprocal function of
\code{deserialize_keras_object()}. See \code{deserialize_keras_object()} for more
information about the full config format.
}
\seealso{
\itemize{
\item \url{https://keras.io/api/models/model_saving_apis/serialization_utils#serializekerasobject-function}
}

Other serialization utilities: \cr
\code{\link{deserialize_keras_object}()} \cr
\code{\link{get_custom_objects}()} \cr
\code{\link{get_registered_name}()} \cr
\code{\link{get_registered_object}()} \cr
\code{\link{register_keras_serializable}()} \cr
\code{\link{with_custom_object_scope}()} \cr
}
\concept{serialization utilities}
