% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applications.R
\name{application_mobilenet_v3_large}
\alias{application_mobilenet_v3_large}
\title{Instantiates the MobileNetV3Large architecture.}
\usage{
application_mobilenet_v3_large(
  input_shape = NULL,
  alpha = 1,
  minimalistic = FALSE,
  include_top = TRUE,
  weights = "imagenet",
  input_tensor = NULL,
  classes = 1000L,
  pooling = NULL,
  dropout_rate = 0.2,
  classifier_activation = "softmax",
  include_preprocessing = TRUE
)
}
\arguments{
\item{input_shape}{Optional shape tuple, to be specified if you would
like to use a model with an input image resolution that is not
\verb{(224, 224, 3)}.
It should have exactly 3 inputs channels.
You can also omit this option if you would like
to infer input_shape from an input_tensor.
If you choose to include both input_tensor and input_shape then
input_shape will be used if they match, if the shapes
do not match then we will throw an error.
E.g. \verb{(160, 160, 3)} would be one valid value.}

\item{alpha}{controls the width of the network. This is known as the
depth multiplier in the MobileNetV3 paper, but the name is kept for
consistency with MobileNetV1 in Keras.
\itemize{
\item If \code{alpha < 1.0}, proportionally decreases the number
of filters in each layer.
\item If \code{alpha > 1.0}, proportionally increases the number
of filters in each layer.
\item If \code{alpha == 1}, default number of filters from the paper
are used at each layer.
}}

\item{minimalistic}{In addition to large and small models this module also
contains so-called minimalistic models, these models have the same
per-layer dimensions characteristic as MobilenetV3 however, they don't
utilize any of the advanced blocks (squeeze-and-excite units,
hard-swish, and 5x5 convolutions).
While these models are less efficient on CPU, they
are much more performant on GPU/DSP.}

\item{include_top}{Boolean, whether to include the fully-connected
layer at the top of the network. Defaults to \code{TRUE}.}

\item{weights}{String, one of \code{NULL} (random initialization),
\code{"imagenet"} (pre-training on ImageNet),
or the path to the weights file to be loaded.}

\item{input_tensor}{Optional Keras tensor (i.e. output of
\code{layers.Input()})
to use as image input for the model.}

\item{classes}{Integer, optional number of classes to classify images
into, only to be specified if \code{include_top} is \code{TRUE}, and
if no \code{weights} argument is specified.}

\item{pooling}{String, optional pooling mode for feature extraction
when \code{include_top} is \code{FALSE}.
\itemize{
\item \code{NULL} means that the output of the model
will be the 4D tensor output of the
last convolutional block.
\item \code{avg} means that global average pooling
will be applied to the output of the
last convolutional block, and thus
the output of the model will be a
2D tensor.
\item \code{max} means that global max pooling will
be applied.
}}

\item{dropout_rate}{fraction of the input units to drop on the last layer.}

\item{classifier_activation}{A \code{str} or callable. The activation function to use
on the "top" layer. Ignored unless \code{include_top=TRUE}. Set
\code{classifier_activation=NULL} to return the logits of the "top" layer.
When loading pretrained weights, \code{classifier_activation} can only
be \code{NULL} or \code{"softmax"}.}

\item{include_preprocessing}{Boolean, whether to include the preprocessing
layer (\code{Rescaling}) at the bottom of the network. Defaults to \code{TRUE}.}
}
\value{
A model instance.
}
\description{
Instantiates the MobileNetV3Large architecture.
}
\section{Reference}{
\itemize{
\item \href{https://arxiv.org/pdf/1905.02244}{Searching for MobileNetV3} (ICCV 2019)
}
\subsection{The following table describes the performance of MobileNets v3:}{

MACs stands for Multiply Adds\tabular{lllll}{
   Classification Checkpoint \tab MACs(M) \tab Parameters(M) \tab Top1 Accuracy \tab Pixel1 CPU(ms) \cr
   mobilenet_v3_large_1.0_224 \tab 217 \tab 5.4 \tab 75.6 \tab 51.2 \cr
   mobilenet_v3_large_0.75_224 \tab 155 \tab 4.0 \tab 73.3 \tab 39.8 \cr
   mobilenet_v3_large_minimalistic_1.0_224 \tab 209 \tab 3.9 \tab 72.3 \tab 44.1 \cr
   mobilenet_v3_small_1.0_224 \tab 66 \tab 2.9 \tab 68.1 \tab 15.8 \cr
   mobilenet_v3_small_0.75_224 \tab 44 \tab 2.4 \tab 65.4 \tab 12.8 \cr
   mobilenet_v3_small_minimalistic_1.0_224 \tab 65 \tab 2.0 \tab 61.9 \tab 12.2 \cr
}


For image classification use cases, see
\href{https://keras.io/api/applications/#usage-examples-for-image-classification-models}{this page for detailed examples}.

For transfer learning use cases, make sure to read the
\href{https://keras.io/guides/transfer_learning/}{guide to transfer learning & fine-tuning}.
}
}

\section{Note}{
Each Keras Application expects a specific kind of input preprocessing.
For MobileNetV3, by default input preprocessing is included as a part of the
model (as a \code{Rescaling} layer), and thus
\code{\link[=application_preprocess_inputs]{application_preprocess_inputs()}} is actually a
pass-through function. In this use case, MobileNetV3 models expect their
inputs to be float tensors of pixels with values in the \verb{[0-255]} range.
At the same time, preprocessing as a part of the model (i.e. \code{Rescaling}
layer) can be disabled by setting \code{include_preprocessing} argument to \code{FALSE}.
With preprocessing disabled MobileNetV3 models expect their inputs to be float
tensors of pixels with values in the \verb{[-1, 1]} range.
}

\section{Call Arguments}{
\itemize{
\item \code{inputs}: A floating point \code{numpy.array} or backend-native tensor,
4D with 3 color channels, with values in the range \verb{[0, 255]}
if \code{include_preprocessing} is \code{TRUE} and in the range \verb{[-1, 1]}
otherwise.
}
}

\seealso{
\itemize{
\item \url{https://keras.io/api/applications/mobilenet#mobilenetv3large-function}
}
}
