% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_source_inputs}
\alias{get_source_inputs}
\title{Returns the list of input tensors necessary to compute \code{tensor}.}
\usage{
get_source_inputs(tensor)
}
\arguments{
\item{tensor}{The tensor to start from.}
}
\value{
List of input tensors.
}
\description{
Output will always be a list of tensors
(potentially with 1 element).
}
\section{Example}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{input <- keras_input(c(3))
output <- input |> layer_dense(4) |> op_multiply(5)
reticulate::py_id(get_source_inputs(output)[[1]]) ==
reticulate::py_id(input)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## [1] TRUE

}\if{html}{\out{</div>}}
}

\seealso{
Other utils: \cr
\code{\link{audio_dataset_from_directory}()} \cr
\code{\link{clear_session}()} \cr
\code{\link{config_disable_interactive_logging}()} \cr
\code{\link{config_disable_traceback_filtering}()} \cr
\code{\link{config_enable_interactive_logging}()} \cr
\code{\link{config_enable_traceback_filtering}()} \cr
\code{\link{config_is_interactive_logging_enabled}()} \cr
\code{\link{config_is_traceback_filtering_enabled}()} \cr
\code{\link{get_file}()} \cr
\code{\link{image_array_save}()} \cr
\code{\link{image_dataset_from_directory}()} \cr
\code{\link{image_from_array}()} \cr
\code{\link{image_load}()} \cr
\code{\link{image_smart_resize}()} \cr
\code{\link{image_to_array}()} \cr
\code{\link{layer_feature_space}()} \cr
\code{\link{normalize}()} \cr
\code{\link{pack_x_y_sample_weight}()} \cr
\code{\link{pad_sequences}()} \cr
\code{\link{set_random_seed}()} \cr
\code{\link{split_dataset}()} \cr
\code{\link{text_dataset_from_directory}()} \cr
\code{\link{timeseries_dataset_from_array}()} \cr
\code{\link{to_categorical}()} \cr
\code{\link{unpack_x_y_sample_weight}()} \cr
\code{\link{zip_lists}()} \cr
}
\concept{utils}
