% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-pooling.R
\name{layer_max_pooling_1d}
\alias{layer_max_pooling_1d}
\title{Max pooling operation for temporal data.}
\usage{
layer_max_pooling_1d(
  object,
  pool_size = 2L,
  strides = NULL,
  padding = "valid",
  data_format = "channels_last",
  batch_size = NULL,
  name = NULL,
  trainable = NULL,
  weights = NULL
)
}
\arguments{
\item{object}{What to call the new \code{Layer} instance with. Typically a keras
\code{Model}, another \code{Layer}, or a \code{tf.Tensor}/\code{KerasTensor}. If \code{object} is
missing, the \code{Layer} instance is returned, otherwise, \code{layer(object)} is
returned.}

\item{pool_size}{Integer, size of the max pooling windows.}

\item{strides}{Integer, or NULL. Factor by which to downscale. E.g. 2 will
halve the input. If NULL, it will default to \code{pool_size}.}

\item{padding}{One of \code{"valid"} or \code{"same"} (case-insensitive).}

\item{data_format}{A string, one of "channels_last" (default) or
"channels_first". The ordering of the dimensions in the inputs.
channels_last corresponds to inputs with shape \verb{(batch, steps, features)}
while channels_first corresponds to inputs with shape \verb{(batch, features, steps)}.}

\item{batch_size}{Fixed batch size for layer}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}

\item{trainable}{Whether the layer weights will be updated during training.}

\item{weights}{Initial weights for layer.}
}
\description{
Max pooling operation for temporal data.
}
\section{Input Shape}{

If data_format='channels_last': 3D tensor with shape \verb{(batch_size, steps, features)}.
If data_format='channels_first': 3D tensor with shape \verb{(batch_size, features, steps)}.
}

\section{Output shape}{

If data_format='channels_last': 3D tensor with shape \verb{(batch_size, downsampled_steps, features)}.
If data_format='channels_first': 3D tensor with shape \verb{(batch_size, features, downsampled_steps)}.
}

\seealso{
Other pooling layers: 
\code{\link{layer_average_pooling_1d}()},
\code{\link{layer_average_pooling_2d}()},
\code{\link{layer_average_pooling_3d}()},
\code{\link{layer_global_average_pooling_1d}()},
\code{\link{layer_global_average_pooling_2d}()},
\code{\link{layer_global_average_pooling_3d}()},
\code{\link{layer_global_max_pooling_1d}()},
\code{\link{layer_global_max_pooling_2d}()},
\code{\link{layer_global_max_pooling_3d}()},
\code{\link{layer_max_pooling_2d}()},
\code{\link{layer_max_pooling_3d}()}
}
\concept{pooling layers}
