% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-convolutional.R
\name{layer_conv_3d}
\alias{layer_conv_3d}
\title{3D convolution layer (e.g. spatial convolution over volumes).}
\usage{
layer_conv_3d(
  object,
  filters,
  kernel_size,
  strides = c(1L, 1L, 1L),
  padding = "valid",
  data_format = NULL,
  dilation_rate = c(1L, 1L, 1L),
  groups = 1L,
  activation = NULL,
  use_bias = TRUE,
  kernel_initializer = "glorot_uniform",
  bias_initializer = "zeros",
  kernel_regularizer = NULL,
  bias_regularizer = NULL,
  activity_regularizer = NULL,
  kernel_constraint = NULL,
  bias_constraint = NULL,
  input_shape = NULL,
  batch_input_shape = NULL,
  batch_size = NULL,
  dtype = NULL,
  name = NULL,
  trainable = NULL,
  weights = NULL
)
}
\arguments{
\item{object}{What to call the new \code{Layer} instance with. Typically a keras
\code{Model}, another \code{Layer}, or a \code{tf.Tensor}/\code{KerasTensor}. If \code{object} is
missing, the \code{Layer} instance is returned, otherwise, \code{layer(object)} is
returned.}

\item{filters}{Integer, the dimensionality of the output space (i.e. the
number of output filters in the convolution).}

\item{kernel_size}{An integer or list of 3 integers, specifying the depth,
height, and width of the 3D convolution window. Can be a single integer
to specify the same value for all spatial dimensions.}

\item{strides}{An integer or list of 3 integers, specifying the strides of
the convolution along each spatial dimension. Can be a single integer to
specify the same value for all spatial dimensions. Specifying any stride
value != 1 is incompatible with specifying any \code{dilation_rate} value != 1.}

\item{padding}{one of \code{"valid"} or \code{"same"} (case-insensitive).}

\item{data_format}{A string, one of \code{channels_last} (default) or
\code{channels_first}. The ordering of the dimensions in the inputs.
\code{channels_last} corresponds to inputs with shape \verb{(batch, spatial_dim1, spatial_dim2, spatial_dim3, channels)} while \code{channels_first} corresponds
to inputs with shape \verb{(batch, channels, spatial_dim1, spatial_dim2, spatial_dim3)}. It defaults to the \code{image_data_format} value found in your
Keras config file at \verb{~/.keras/keras.json}. If you never set it, then it
will be "channels_last".}

\item{dilation_rate}{an integer or list of 3 integers, specifying the
dilation rate to use for dilated convolution. Can be a single integer to
specify the same value for all spatial dimensions. Currently, specifying
any \code{dilation_rate} value != 1 is incompatible with specifying any stride
value != 1.}

\item{groups}{A positive integer specifying the number of groups in which the
input is split along the channel axis. Each group is convolved separately
with \code{filters / groups} filters. The output is the concatenation of all the
groups results along the channel axis. Input channels and \code{filters} must both
be divisible by \code{groups}.}

\item{activation}{Activation function to use. If you don't specify anything,
no activation is applied (ie. "linear" activation: \code{a(x) = x}).}

\item{use_bias}{Boolean, whether the layer uses a bias vector.}

\item{kernel_initializer}{Initializer for the \code{kernel} weights matrix.}

\item{bias_initializer}{Initializer for the bias vector.}

\item{kernel_regularizer}{Regularizer function applied to the \code{kernel}
weights matrix.}

\item{bias_regularizer}{Regularizer function applied to the bias vector.}

\item{activity_regularizer}{Regularizer function applied to the output of the
layer (its "activation")..}

\item{kernel_constraint}{Constraint function applied to the kernel matrix.}

\item{bias_constraint}{Constraint function applied to the bias vector.}

\item{input_shape}{Dimensionality of the input (integer) not including the
samples axis. This argument is required when using this layer as the first
layer in a model.}

\item{batch_input_shape}{Shapes, including the batch size. For instance,
\code{batch_input_shape=c(10, 32)} indicates that the expected input will be
batches of 10 32-dimensional vectors. \code{batch_input_shape=list(NULL, 32)}
indicates batches of an arbitrary number of 32-dimensional vectors.}

\item{batch_size}{Fixed batch size for layer}

\item{dtype}{The data type expected by the input, as a string (\code{float32},
\code{float64}, \code{int32}...)}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}

\item{trainable}{Whether the layer weights will be updated during training.}

\item{weights}{Initial weights for layer.}
}
\description{
This layer creates a convolution kernel that is convolved with the layer
input to produce a tensor of outputs. If \code{use_bias} is TRUE, a bias vector is
created and added to the outputs. Finally, if \code{activation} is not \code{NULL}, it
is applied to the outputs as well. When using this layer as the first layer
in a model, provide the keyword argument \code{input_shape} (list of integers,
does not include the sample axis), e.g. \code{input_shape=c(128L, 128L, 128L, 3L)}
for 128x128x128 volumes with a single channel, in
\code{data_format="channels_last"}.
}
\section{Input shape}{
 5D tensor with shape: \verb{(samples, channels, conv_dim1, conv_dim2, conv_dim3)} if data_format='channels_first' or 5D tensor with
shape: \verb{(samples, conv_dim1, conv_dim2, conv_dim3, channels)} if
data_format='channels_last'.
}

\section{Output shape}{
 5D tensor with shape: \verb{(samples, filters, new_conv_dim1, new_conv_dim2, new_conv_dim3)} if
data_format='channels_first' or 5D tensor with shape: \verb{(samples, new_conv_dim1, new_conv_dim2, new_conv_dim3, filters)} if
data_format='channels_last'. \code{new_conv_dim1}, \code{new_conv_dim2} and
\code{new_conv_dim3} values might have changed due to padding.
}

\seealso{
Other convolutional layers: 
\code{\link{layer_conv_1d_transpose}()},
\code{\link{layer_conv_1d}()},
\code{\link{layer_conv_2d_transpose}()},
\code{\link{layer_conv_2d}()},
\code{\link{layer_conv_3d_transpose}()},
\code{\link{layer_conv_lstm_2d}()},
\code{\link{layer_cropping_1d}()},
\code{\link{layer_cropping_2d}()},
\code{\link{layer_cropping_3d}()},
\code{\link{layer_depthwise_conv_2d}()},
\code{\link{layer_separable_conv_1d}()},
\code{\link{layer_separable_conv_2d}()},
\code{\link{layer_upsampling_1d}()},
\code{\link{layer_upsampling_2d}()},
\code{\link{layer_upsampling_3d}()},
\code{\link{layer_zero_padding_1d}()},
\code{\link{layer_zero_padding_2d}()},
\code{\link{layer_zero_padding_3d}()}
}
\concept{convolutional layers}
