% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-noise.R
\name{layer_gaussian_noise}
\alias{layer_gaussian_noise}
\title{Apply additive zero-centered Gaussian noise.}
\usage{
layer_gaussian_noise(
  object,
  stddev,
  input_shape = NULL,
  batch_input_shape = NULL,
  batch_size = NULL,
  dtype = NULL,
  name = NULL,
  trainable = NULL,
  weights = NULL
)
}
\arguments{
\item{object}{What to call the new \code{Layer} instance with. Typically a keras
\code{Model}, another \code{Layer}, or a \code{tf.Tensor}/\code{KerasTensor}. If \code{object} is
missing, the \code{Layer} instance is returned, otherwise, \code{layer(object)} is
returned.}

\item{stddev}{float, standard deviation of the noise distribution.}

\item{input_shape}{Dimensionality of the input (integer) not including the
samples axis. This argument is required when using this layer as the first
layer in a model.}

\item{batch_input_shape}{Shapes, including the batch size. For instance,
\code{batch_input_shape=c(10, 32)} indicates that the expected input will be
batches of 10 32-dimensional vectors. \code{batch_input_shape=list(NULL, 32)}
indicates batches of an arbitrary number of 32-dimensional vectors.}

\item{batch_size}{Fixed batch size for layer}

\item{dtype}{The data type expected by the input, as a string (\code{float32},
\code{float64}, \code{int32}...)}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}

\item{trainable}{Whether the layer weights will be updated during training.}

\item{weights}{Initial weights for layer.}
}
\description{
This is useful to mitigate overfitting (you could see it as a form of random
data augmentation). Gaussian Noise (GS) is a natural choice as corruption
process for real valued inputs. As it is a regularization layer, it is only
active at training time.
}
\section{Input shape}{
 Arbitrary. Use the keyword argument \code{input_shape} (list
of integers, does not include the samples axis) when using this layer as
the first layer in a model.
}

\section{Output shape}{
 Same shape as input.
}

\seealso{
Other noise layers: 
\code{\link{layer_alpha_dropout}()},
\code{\link{layer_gaussian_dropout}()}
}
\concept{noise layers}
