% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-activations.R
\name{layer_activation_elu}
\alias{layer_activation_elu}
\title{Exponential Linear Unit.}
\usage{
layer_activation_elu(
  object,
  alpha = 1,
  input_shape = NULL,
  batch_input_shape = NULL,
  batch_size = NULL,
  dtype = NULL,
  name = NULL,
  trainable = NULL,
  weights = NULL
)
}
\arguments{
\item{object}{What to call the new \code{Layer} instance with. Typically a keras
\code{Model}, another \code{Layer}, or a \code{tf.Tensor}/\code{KerasTensor}. If \code{object} is
missing, the \code{Layer} instance is returned, otherwise, \code{layer(object)} is
returned.}

\item{alpha}{Scale for the negative factor.}

\item{input_shape}{Input shape (list of integers, does not include the
samples axis) which is required when using this layer as the first layer in
a model.}

\item{batch_input_shape}{Shapes, including the batch size. For instance,
\code{batch_input_shape=c(10, 32)} indicates that the expected input will be
batches of 10 32-dimensional vectors. \code{batch_input_shape=list(NULL, 32)}
indicates batches of an arbitrary number of 32-dimensional vectors.}

\item{batch_size}{Fixed batch size for layer}

\item{dtype}{The data type expected by the input, as a string (\code{float32},
\code{float64}, \code{int32}...)}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}

\item{trainable}{Whether the layer weights will be updated during training.}

\item{weights}{Initial weights for layer.}
}
\description{
It follows: \code{f(x) =  alpha * (exp(x) - 1.0)} for \code{x < 0}, \code{f(x) = x} for \code{x >= 0}.
}
\seealso{
\href{https://arxiv.org/abs/1511.07289v1}{Fast and Accurate Deep Network Learning by Exponential Linear Units (ELUs)}.

Other activation layers: 
\code{\link{layer_activation_leaky_relu}()},
\code{\link{layer_activation_parametric_relu}()},
\code{\link{layer_activation_relu}()},
\code{\link{layer_activation_selu}()},
\code{\link{layer_activation_softmax}()},
\code{\link{layer_activation_thresholded_relu}()},
\code{\link{layer_activation}()}
}
\concept{activation layers}
