% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initializers.R
\name{initializer_glorot_normal}
\alias{initializer_glorot_normal}
\title{Glorot normal initializer, also called Xavier normal initializer.}
\usage{
initializer_glorot_normal(seed = NULL)
}
\arguments{
\item{seed}{Integer used to seed the random generator.}
}
\description{
It draws samples from a truncated normal distribution centered on 0
with \code{stddev = sqrt(2 / (fan_in + fan_out))}
where \code{fan_in} is the number of input units in the weight tensor
and \code{fan_out} is the number of output units in the weight tensor.
}
\section{References}{

Glorot & Bengio, AISTATS 2010 \url{https://jmlr.org/proceedings/papers/v9/glorot10a/glorot10a.pdf}
}

\seealso{
Other initializers: 
\code{\link{initializer_constant}()},
\code{\link{initializer_glorot_uniform}()},
\code{\link{initializer_he_normal}()},
\code{\link{initializer_he_uniform}()},
\code{\link{initializer_identity}()},
\code{\link{initializer_lecun_normal}()},
\code{\link{initializer_lecun_uniform}()},
\code{\link{initializer_ones}()},
\code{\link{initializer_orthogonal}()},
\code{\link{initializer_random_normal}()},
\code{\link{initializer_random_uniform}()},
\code{\link{initializer_truncated_normal}()},
\code{\link{initializer_variance_scaling}()},
\code{\link{initializer_zeros}()}
}
\concept{initializers}
