% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\name{constraints}
\alias{constraints}
\alias{constraint_maxnorm}
\alias{constraint_nonneg}
\alias{constraint_unitnorm}
\alias{constraint_minmaxnorm}
\title{Weight constraints}
\usage{
constraint_maxnorm(max_value = 2, axis = 0)

constraint_nonneg()

constraint_unitnorm(axis = 0)

constraint_minmaxnorm(min_value = 0, max_value = 1, rate = 1, axis = 0)
}
\arguments{
\item{max_value}{The maximum norm for the incoming weights.}

\item{axis}{The axis along which to calculate weight norms. For instance, in
a dense layer the weight matrix has shape \verb{input_dim, output_dim}, set
\code{axis} to \code{0} to constrain each weight vector of length \verb{input_dim,}. In a
convolution 2D layer with \code{dim_ordering="tf"}, the weight tensor has shape
\verb{rows, cols, input_depth, output_depth}, set \code{axis} to \code{c(0, 1, 2)} to
constrain the weights of each filter tensor of size \verb{rows, cols, input_depth}.}

\item{min_value}{The minimum norm for the incoming weights.}

\item{rate}{The rate for enforcing the constraint: weights will be rescaled to
yield (1 - rate) * norm + rate * norm.clip(low, high). Effectively, this
means that rate=1.0 stands for strict enforcement of the constraint, while
rate<1.0 means that weights will be rescaled at each step to slowly move
towards a value inside the desired interval.}
}
\description{
Functions that impose constraints on weight values.
}
\details{
\itemize{
\item \code{constraint_maxnorm()} constrains the weights incident to each
hidden unit to have a norm less than or equal to a desired value.
\item \code{constraint_nonneg()} constraints the weights to be non-negative
\item \code{constraint_unitnorm()} constrains the weights incident to each hidden
unit to have unit norm.
\item \code{constraint_minmaxnorm()} constrains the weights incident to each
hidden unit to have the norm between a lower bound and an upper bound.
}
}
\section{Custom constraints}{


You can implement your own constraint functions in R. A custom
constraint is an R function that takes weights (\code{w}) as input
and returns modified weights. Note that keras \code{\link[=backend]{backend()}} tensor
functions (e.g. \code{\link[=k_greater_equal]{k_greater_equal()}}) should be used in the
implementation of custom constraints. For example:\if{html}{\out{<div class="r">}}\preformatted{nonneg_constraint <- function(w) \{
  w * k_cast(k_greater_equal(w, 0), k_floatx())
\}

layer_dense(units = 32, input_shape = c(784), 
            kernel_constraint = nonneg_constraint)
}\if{html}{\out{</div>}}

Note that models which use custom constraints cannot be serialized using
\code{\link[=save_model_hdf5]{save_model_hdf5()}}. Rather, the weights of the model should be saved
and restored using \code{\link[=save_model_weights_hdf5]{save_model_weights_hdf5()}}.
}

\seealso{
\href{https://www.cs.toronto.edu/~rsalakhu/papers/srivastava14a.pdf}{Dropout: A Simple Way to Prevent Neural Networks from Overfitting Srivastava, Hinton, et al. 2014}

\link{KerasConstraint}
}
