% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer-wrappers.R
\name{time_distributed}
\alias{time_distributed}
\title{This layer wrapper allows to apply a layer to every temporal slice of an input}
\usage{
time_distributed(object, layer, ...)
}
\arguments{
\item{object}{What to compose the new \code{Layer} instance with. Typically a
Sequential model or a Tensor (e.g., as returned by \code{layer_input()}).
The return value depends on \code{object}. If \code{object} is:
\itemize{
\item missing or \code{NULL}, the \code{Layer} instance is returned.
\item a \code{Sequential} model, the model with an additional layer is returned.
\item a Tensor, the output tensor from \code{layer_instance(object)} is returned.
}}

\item{layer}{a \code{tf.keras.layers.Layer} instance.}

\item{...}{standard layer arguments.}
}
\description{
This layer wrapper allows to apply a layer to every temporal slice of an input
}
\details{
Every input should be at least 3D, and the dimension of index one of the
first input will be considered to be the temporal dimension.

Consider a batch of 32 video samples, where each sample is a 128x128 RGB image
with \code{channels_last} data format, across 10 timesteps.
The batch input shape is \verb{(32, 10, 128, 128, 3)}.

You can then use \code{TimeDistributed} to apply the same \code{Conv2D} layer to each
of the 10 timesteps, independently:

\if{html}{\out{<div class="sourceCode R">}}\preformatted{input <- layer_input(c(10, 128, 128, 3))
conv_layer <- layer_conv_2d(filters = 64, kernel_size = c(3, 3))
output <- input \%>\% time_distributed(conv_layer)
output$shape # TensorShape([None, 10, 126, 126, 64])
}\if{html}{\out{</div>}}

Because \code{TimeDistributed} applies the same instance of \code{Conv2D} to each of the
timestamps, the same set of weights are used at each timestamp.
}
\seealso{
\itemize{
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/layers/TimeDistributed}
}

Other layer wrappers: 
\code{\link{bidirectional}()}
}
\concept{layer wrappers}
