% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-convolutional.R
\name{layer_conv_2d_transpose}
\alias{layer_conv_2d_transpose}
\title{Transposed 2D convolution layer (sometimes called Deconvolution).}
\usage{
layer_conv_2d_transpose(object, filters, kernel_size, strides = c(1L, 1L),
  padding = "valid", data_format = NULL, activation = NULL,
  use_bias = TRUE, kernel_initializer = "glorot_uniform",
  bias_initializer = "zeros", kernel_regularizer = NULL,
  bias_regularizer = NULL, activity_regularizer = NULL,
  kernel_constraint = NULL, bias_constraint = NULL, input_shape = NULL,
  batch_input_shape = NULL, batch_size = NULL, dtype = NULL,
  name = NULL, trainable = NULL, weights = NULL)
}
\arguments{
\item{object}{Model or layer object}

\item{filters}{Integer, the dimensionality of the output space (i.e. the
number of output filters in the convolution).}

\item{kernel_size}{An integer or list of 2 integers, specifying the width and
height of the 2D convolution window. Can be a single integer to specify the
same value for all spatial dimensions.}

\item{strides}{An integer or list of 2 integers, specifying the strides of
the convolution along the width and height. Can be a single integer to
specify the same value for all spatial dimensions. Specifying any stride
value != 1 is incompatible with specifying any \code{dilation_rate} value != 1.}

\item{padding}{one of \code{"valid"} or \code{"same"} (case-insensitive).}

\item{data_format}{A string, one of \code{channels_last} (default) or
\code{channels_first}. The ordering of the dimensions in the inputs.
\code{channels_last} corresponds to inputs with shape \code{(batch, height, width, channels)} while \code{channels_first} corresponds to inputs with shape \code{(batch, channels, height, width)}. It defaults to the \code{image_data_format} value
found in your Keras config file at \code{~/.keras/keras.json}. If you never set
it, then it will be "channels_last".}

\item{activation}{Activation function to use. If you don't specify anything,
no activation is applied (ie. "linear" activation: \code{a(x) = x}).}

\item{use_bias}{Boolean, whether the layer uses a bias vector.}

\item{kernel_initializer}{Initializer for the \code{kernel} weights matrix.}

\item{bias_initializer}{Initializer for the bias vector.}

\item{kernel_regularizer}{Regularizer function applied to the \code{kernel}
weights matrix.}

\item{bias_regularizer}{Regularizer function applied to the bias vector.}

\item{activity_regularizer}{Regularizer function applied to the output of the
layer (its "activation")..}

\item{kernel_constraint}{Constraint function applied to the kernel matrix.}

\item{bias_constraint}{Constraint function applied to the bias vector.}

\item{input_shape}{Dimensionality of the input (integer) not including the
samples axis. This argument is required when using this layer as the first
layer in a model.}

\item{batch_input_shape}{Shapes, including the batch size. For instance,
\code{batch_input_shape=c(10, 32)} indicates that the expected input will be
batches of 10 32-dimensional vectors. \code{batch_input_shape=list(NULL, 32)}
indicates batches of an arbitrary number of 32-dimensional vectors.}

\item{batch_size}{Fixed batch size for layer}

\item{dtype}{The data type expected by the input, as a string (\code{float32},
\code{float64}, \code{int32}...)}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}

\item{trainable}{Whether the layer weights will be updated during training.}

\item{weights}{Initial weights for layer.}
}
\description{
The need for transposed convolutions generally arises from the desire to use
a transformation going in the opposite direction of a normal convolution,
i.e., from something that has the shape of the output of some convolution to
something that has the shape of its input while maintaining a connectivity
pattern that is compatible with said convolution. When using this layer as
the first layer in a model, provide the keyword argument \code{input_shape} (list
of integers, does not include the sample axis), e.g. \code{input_shape=c(128L, 128L, 3L)} for 128x128 RGB pictures in \code{data_format="channels_last"}.
}
\section{Input shape}{
 4D tensor with shape: \code{(batch, channels, rows, cols)}
if data_format='channels_first' or 4D tensor with shape: \code{(batch, rows, cols, channels)} if data_format='channels_last'.
}

\section{Output shape}{
 4D tensor with shape: \code{(batch, filters, new_rows, new_cols)} if data_format='channels_first' or 4D tensor with shape:
\code{(batch, new_rows, new_cols, filters)} if data_format='channels_last'.
\code{rows} and \code{cols} values might have changed due to padding.
}

\section{References}{

\itemize{
\item \href{https://arxiv.org/abs/1603.07285v1}{A guide to convolution arithmetic for deep learning}
\item \href{https://www.uoguelph.ca/~gwtaylor/publications/mattcvpr2010/deconvolutionalnets.pdf}{Deconvolutional Networks}
}
}

\seealso{
Other convolutional layers: \code{\link{layer_conv_1d}},
  \code{\link{layer_conv_2d}},
  \code{\link{layer_conv_3d_transpose}},
  \code{\link{layer_conv_3d}},
  \code{\link{layer_conv_lstm_2d}},
  \code{\link{layer_cropping_1d}},
  \code{\link{layer_cropping_2d}},
  \code{\link{layer_cropping_3d}},
  \code{\link{layer_depthwise_conv_2d}},
  \code{\link{layer_separable_conv_1d}},
  \code{\link{layer_separable_conv_2d}},
  \code{\link{layer_upsampling_1d}},
  \code{\link{layer_upsampling_2d}},
  \code{\link{layer_upsampling_3d}},
  \code{\link{layer_zero_padding_1d}},
  \code{\link{layer_zero_padding_2d}},
  \code{\link{layer_zero_padding_3d}}
}
