% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{flow_images_from_directory}
\alias{flow_images_from_directory}
\title{Generates batches of data from images in a directory (with optional
augmented/normalized data)}
\usage{
flow_images_from_directory(directory, generator = image_data_generator(),
  target_size = c(256, 256), color_mode = "rgb", classes = NULL,
  class_mode = "categorical", batch_size = 32, shuffle = TRUE,
  seed = NULL, save_to_dir = NULL, save_prefix = "",
  save_format = "png", follow_links = FALSE, interpolation = "nearest")
}
\arguments{
\item{directory}{path to the target directory. It should contain one
subdirectory per class. Any PNG, JPG, BMP, PPM, or TIF images inside each
of the subdirectories directory tree will be included in the generator.
See \href{https://gist.github.com/fchollet/0830affa1f7f19fd47b06d4cf89ed44d}{this script}
for more details.}

\item{generator}{Image data generator (default generator does no data
augmentation/normalization transformations)}

\item{target_size}{integer vectir, default: \code{c(256, 256)}. The dimensions to
which all images found will be resized.}

\item{color_mode}{one of "grayscale", "rbg". Default: "rgb". Whether the
images will be converted to have 1 or 3 color channels.}

\item{classes}{optional list of class subdirectories (e.g. \code{c('dogs', 'cats')}). Default: \code{NULL}, If not provided, the list of classes will be
automatically inferred (and the order of the classes, which will map to
the label indices, will be alphanumeric).}

\item{class_mode}{one of "categorical", "binary", "sparse" or \code{NULL}.
Default: "categorical". Determines the type of label arrays that are
returned: "categorical" will be 2D one-hot encoded labels, "binary" will
be 1D binary labels, "sparse" will be 1D integer labels. If \code{NULL}, no
labels are returned (the generator will only yield batches of image data,
which is useful to use \code{\link[=predict_generator]{predict_generator()}}, \code{\link[=evaluate_generator]{evaluate_generator()}},
etc.).}

\item{batch_size}{int (default: \code{32}).}

\item{shuffle}{boolean (defaut: \code{TRUE}).}

\item{seed}{int (default: \code{NULL}).}

\item{save_to_dir}{\code{NULL} or str (default: \code{NULL}). This allows you to
optionally specify a directory to which to save the augmented pictures being
generated (useful for visualizing what you are doing).}

\item{save_prefix}{str (default: ''). Prefix to use for filenames of saved
pictures (only relevant if \code{save_to_dir} is set).}

\item{save_format}{one of "png", "jpeg" (only relevant if save_to_dir is
set). Default: "png".}

\item{follow_links}{whether to follow symlinks inside class subdirectories
(default: \code{FALSE})}

\item{interpolation}{Interpolation method used to resample the image if the
target size is different from that of the loaded image. Supported methods
are "nearest", "bilinear", and "bicubic". If PIL version 1.1.3 or newer is
installed, "lanczos" is also supported. If PIL version 3.4.0 or newer is
installed, "box" and "hamming" are also supported. By default, "nearest"
is used.}
}
\description{
Generates batches of data from images in a directory (with optional
augmented/normalized data)
}
\details{
Yields batches indefinitely, in an infinite loop.
}
\section{Yields}{
 \code{(x, y)} where \code{x} is an array of image data and \code{y} is a
array of corresponding labels. The generator loops indefinitely.
}

\seealso{
Other image preprocessing: \code{\link{fit_image_data_generator}},
  \code{\link{flow_images_from_data}},
  \code{\link{image_load}}, \code{\link{image_to_array}}
}
