% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-pooling.R
\name{layer_average_pooling_1d}
\alias{layer_average_pooling_1d}
\title{Average pooling for temporal data.}
\usage{
layer_average_pooling_1d(object, pool_size = 2L, strides = NULL,
  padding = "valid", batch_size = NULL, name = NULL, trainable = NULL,
  weights = NULL)
}
\arguments{
\item{object}{Model or layer object}

\item{pool_size}{Integer, size of the max pooling windows.}

\item{strides}{Integer, or NULL. Factor by which to downscale. E.g. 2 will
halve the input. If NULL, it will default to \code{pool_size}.}

\item{padding}{One of \code{"valid"} or \code{"same"} (case-insensitive).}

\item{batch_size}{Fixed batch size for layer}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}

\item{trainable}{Whether the layer weights will be updated during training.}

\item{weights}{Initial weights for layer.}
}
\description{
Average pooling for temporal data.
}
\section{Input shape}{
 3D tensor with shape: \code{(batch_size, steps, features)}.
}

\section{Output shape}{
 3D tensor with shape: \code{(batch_size, downsampled_steps, features)}.
}

\seealso{
Other pooling layers: \code{\link{layer_average_pooling_2d}},
  \code{\link{layer_average_pooling_3d}},
  \code{\link{layer_global_average_pooling_1d}},
  \code{\link{layer_global_average_pooling_2d}},
  \code{\link{layer_global_average_pooling_3d}},
  \code{\link{layer_global_max_pooling_1d}},
  \code{\link{layer_global_max_pooling_2d}},
  \code{\link{layer_global_max_pooling_3d}},
  \code{\link{layer_max_pooling_1d}},
  \code{\link{layer_max_pooling_2d}},
  \code{\link{layer_max_pooling_3d}}
}
