# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' fits a kernel density estimate and calculates the effective degrees of
#' freedom.
#' @param x vector of observations; categorical data must be converted to
#'   non-negative integers.
#' @param xmin lower bound for the support of the density, `NaN` means no
#'   boundary.
#' @param xmax upper bound for the support of the density, `NaN` means no
#'   boundary.
#' @param type variable type; must be one of {c, cont, continuous} for
#'   continuous variables, one of {d, disc, discrete} for discrete integer
#'   variables, or one of {zi, zinfl, zero-inflated} for zero-inflated
#'   variables.
#' @param bandwidth the bandwidth parameter.
#' @param mult positive bandwidth multiplier; the actual bandwidth used is
#'   bw*mult.
#' @param degree order of the local polynomial.
#' @return `An Rcpp::List` containing the fitted density values on a grid and
#'   additional information.
#' @noRd
fit_kde1d_cpp <- function(x, xmin, xmax, type, mult, bandwidth, degree, weights) {
    .Call('_kde1d_fit_kde1d_cpp', PACKAGE = 'kde1d', x, xmin, xmax, type, mult, bandwidth, degree, weights)
}

#' computes the pdf of a kernel density estimate by interpolation.
#' @param x vector of evaluation points.
#' @param kde1d_r the fitted object passed from R.
#' @return a vector of pdf values.
#' @noRd
dkde1d_cpp <- function(x, kde1d_r) {
    .Call('_kde1d_dkde1d_cpp', PACKAGE = 'kde1d', x, kde1d_r)
}

#' computes the cdf of a kernel density estimate by numerical integration.
#' @param x vector of evaluation points.
#' @param kde1d_r the fitted object passed from R.
#' @return a vector of cdf values.
#' @noRd
pkde1d_cpp <- function(q, kde1d_r) {
    .Call('_kde1d_pkde1d_cpp', PACKAGE = 'kde1d', q, kde1d_r)
}

#' computes the quantile of a kernel density estimate by numerical inversion
#' (bisection method).
#' @param x vector of evaluation points.
#' @param kde1d_r the fitted object passed from R.
#' @return a vector of quantiles.
#' @noRd
qkde1d_cpp <- function(p, kde1d_r) {
    .Call('_kde1d_qkde1d_cpp', PACKAGE = 'kde1d', p, kde1d_r)
}

