% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{assayBoxPlot}
\alias{assayBoxPlot}
\title{Generate a box plot from assay data}
\usage{
assayBoxPlot(
  TapestriExperiment,
  alt.exp = NULL,
  assay = NULL,
  log.y = TRUE,
  split.features = FALSE,
  split.x.by = NULL,
  split.y.by = NULL
)
}
\arguments{
\item{TapestriExperiment}{\code{TapestriExperiment} object}

\item{alt.exp}{Character, \code{altExp} to plot. \code{NULL} (default) uses the top-level experiment in \code{TapestriExperiment}.}

\item{assay}{Character, assay to plot. \code{NULL} (default) selects first assay listed \code{TapestriExperiment}.}

\item{log.y}{Logical, if \code{TRUE}, scales data using \code{log1p()}. Default \code{TRUE.}}

\item{split.features}{Logical, if \code{TRUE}, splits plot by \code{rowData} features if slot has more than one row feature/probe. Default \code{FALSE.}}

\item{split.x.by}{Character, \code{colData} column to use for X-axis categories. Default \code{NULL}.}

\item{split.y.by}{Character, \code{colData} column to use for Y-axis splitting/faceting. Default \code{NULL}.}
}
\value{
ggplot object, box plot
}
\description{
Draws box plot of data from indicated \code{TapestriExperiment} \code{assay} slot.
This is especially useful for visualizing \code{altExp} count data, such as counts from
probes on chrY or barcode probe counts.
}
\examples{
tap.object <- newTapestriExperimentExample() # example TapestriExperiment object
assayBoxPlot(tap.object, alt.exp = "chrYCounts", split.features = TRUE, split.x.by = "test.cluster")
}
\seealso{
\code{\link[ggplot2:geom_boxplot]{ggplot2::geom_boxplot()}}
}
\concept{plots}
