% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kanji2.R
\name{kmatdist}
\alias{kmatdist}
\title{Compute the unbalanced or balanced Wasserstein distance between two kanjimat objects}
\usage{
kmatdist(
  k1,
  k2,
  p = 1,
  C = 0.2,
  type = c("unbalanced", "balanced"),
  output = c("dist", "all")
)
}
\arguments{
\item{k1, k2}{two objects of type \code{kanjimat}.}

\item{p}{the order of the Wasserstein distance. All distances and a potential penalty are taken
to the \code{p}-th power (which is compensated by taking the \code{p}-th root after summation).}

\item{C}{the penalty for extra mass if \code{type="unbalanced"}, i.e. we add  \code{C^p} per unit
of extra mass (before applying the \code{p}-th root).}

\item{type}{the type of Wasserstein metric. \code{"unbalanced"} means the pixel values in the two images are
interpreted as mass. The total masses can be very different. Extra mass can be disposed of at cost \code{C^p}
per unit. \code{"balanced"} means the pixel values are normalized so that both images have the same total
mass 1. Everything has to be transported, i.e. disposal of mass is not allowed.}

\item{output}{the requested output. See return value below.}
}
\value{
If \code{output = "dist"}, a single non-negative number: the unbalanced or balanced Wasserstein
distance between the kanji. If \code{output = "all"} a list with detailed information on the transport plan
and the disposal of pixel mass. See \code{\link[transport]{unbalanced}} for details.
}
\description{
This gives the dissimilarity of pixel-images of the kanji based on how far mass (or "ink") has to be
transported to transform one image into the other.
}
\examples{
res <- kmatdist(fivetrees1[[1]], fivetrees1[[5]], p=1, C=0.1, output="all")
plot(res, what="plan", angle=20, lwd=1.5) 
plot(res, what="trans")
plot(res, what="extra")
plot(res, what="inplace")

}
\seealso{
\code{\link{kmatdistmat}}, \code{\link{kanjidist}}
}
