% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lkmt.r
\docType{class}
\name{lkmt-class}
\alias{lkmt-class}
\alias{lkmt}
\alias{show,lkmt-method}
\alias{show,GWASdata,ANY-method}
\alias{summary,lkmt-method}
\alias{summary,GWASdata,ANY-method}
\title{An S4 class to represent the variance component test.}
\usage{
\S4method{show}{lkmt}(object)

\S4method{summary}{lkmt}(object)
}
\arguments{
\item{object}{An object of class \code{lkmt}.}
}
\value{
\code{show} Basic information on \code{lkmt} object.

\code{summary} Summarized information on \code{lkmt} object.
}
\description{
An S4 class to represent the variance component test.

\code{show} displays basic information on \code{lkmt} object

\code{summary} generates a \code{lkmt} object summary including the used kernel, pathway and the test result
}
\section{Slots}{

\describe{
\item{\code{formula}}{A formula stating the regression nullmodel that will be used in
the variance component test.}

\item{\code{kernel}}{An object of class \code{\link{kernel}} representing the similarity
matrix of the individuals based on which the pathways influence is evaluated.}

\item{\code{GWASdata}}{An object of class \code{\link{GWASdata}} including the data
on which the test is conducted.}

\item{\code{statistic}}{A \code{vector} giving the value of the variance component
test statistic.}

\item{\code{df}}{A \code{vector} containing the number of degrees of freedom.}

\item{\code{p.value}}{A \code{vector} giving the p-value calculated for the \code{\link{pathway}} object considered in the variance component test.

For details on the variance component test see the references.}
}}

\examples{
data(hsa04020)
data(gwas)
# compute kernel
net_kernel <- calc_kernel(gwas, hsa04020, knots=NULL, type='net', calculation='cpu')
# perform LKMT 
res <- lkmt_test(pheno ~ sex + age, net_kernel, gwas, method='satt')
# show and summary methods
show(res)
summary(res)
# summary method
summary(lkmt.net.kernel.hsa04020)
}
\references{
\itemize{
\item  Liu D, Lin X, Ghosh D: Semiparametric regression of multidimensional genetic pathway data: least-squares kernel machines and linear mixed models. Biometrics 2007, 63(4):1079-88.
 \item Wu MC, Kraft P, Epstein MP, Taylor DM, Chanock SJ, Hunter DJ, Lin X: Powerful SNP-Set Analysis for Case-Control Genome-Wide Association Studies. Am J Hum Genet 2010, 86:929-42
}
}
\author{
Juliane Manitz, Stefanie Friedrichs
}
