% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/event_date.R
\docType{methods}
\name{predict_event}
\alias{predict_event}
\alias{predict_event-method}
\alias{predict_accumulation}
\alias{predict_accumulation-method}
\alias{predict_event,EventDate,missing-method}
\alias{predict_event,EventDate,matrix-method}
\alias{predict_accumulation,EventDate,missing-method}
\alias{predict_accumulation,EventDate,matrix-method}
\title{Predict Event and Accumulation Dates}
\usage{
predict_event(object, data, ...)

predict_accumulation(object, data, ...)

\S4method{predict_event}{EventDate,missing}(
  object,
  margin = 1,
  level = 0.95,
  calendar = getOption("kairos.calendar")
)

\S4method{predict_event}{EventDate,matrix}(
  object,
  data,
  margin = 1,
  level = 0.95,
  calendar = getOption("kairos.calendar")
)

\S4method{predict_accumulation}{EventDate,missing}(
  object,
  level = 0.95,
  calendar = getOption("kairos.calendar")
)

\S4method{predict_accumulation}{EventDate,matrix}(
  object,
  data,
  level = 0.95,
  calendar = getOption("kairos.calendar")
)
}
\arguments{
\item{object}{An \code{\linkS4class{EventDate}} object.}

\item{data}{A \code{numeric} \code{\link{matrix}} or a \code{\link{data.frame}} of count data
(absolute frequencies) for which to predict event and accumulation dates.}

\item{...}{Further arguments to be passed to internal methods.}

\item{margin}{A \code{\link{numeric}} vector giving the subscripts which the prediction
will be applied over: \code{1} indicates rows, \code{2} indicates columns.}

\item{level}{A length-one \code{\link{numeric}} vector giving the confidence level.}

\item{calendar}{An \code{\link[aion:TimeScale-class]{aion::TimeScale}} object specifying the target
calendar (see \code{\link[aion:calendar]{aion::calendar()}}). If \code{NULL}, \emph{rata die} are returned.}
}
\value{
A \code{\link{data.frame}}.
}
\description{
Estimates the event and accumulation dates of an assemblage.
}
\examples{
## Data from Peeples and Schachner 2012
data("zuni", package = "folio")

## Assume that some assemblages are reliably dated (this is NOT a real example)
zuni_dates <- c(
  LZ0569 = 1097, LZ0279 = 1119, CS16 = 1328, LZ0066 = 1111,
  LZ0852 = 1216, LZ1209 = 1251, CS144 = 1262, LZ0563 = 1206,
  LZ0329 = 1076, LZ0005Q = 859, LZ0322 = 1109, LZ0067 = 863,
  LZ0578 = 1180, LZ0227 = 1104, LZ0610 = 1074
)

## Model the event and accumulation date for each assemblage
model <- event(zuni, zuni_dates, rank = 10)
plot(model, select = 1:10, event = TRUE, flip = TRUE)
}
\references{
Bellanger, L. & Husi, P. (2013). Mesurer et modéliser le temps inscrit dans
la matière à partir d'une source matérielle : la céramique médiévale.
In \emph{Mesure et Histoire Médiévale}. Histoire ancienne et médiévale.
Paris: Publication de la Sorbonne, p. 119-134.

Bellanger, L. & Husi, P. (2012). Statistical Tool for Dating and
Interpreting Archaeological Contexts Using Pottery. \emph{Journal of
Archaeological Science}, 39(4), 777-790. \doi{10.1016/j.jas.2011.06.031}.

Bellanger, L., Tomassone, R. & Husi, P. (2008). A Statistical Approach for
Dating Archaeological Contexts. \emph{Journal of Data Science}, 6, 135-154.

Bellanger, L., Husi, P. & Tomassone, R. (2006). Une approche statistique
pour la datation de contextes archéologiques. \emph{Revue de Statistique
Appliquée}, 54(2), 65-81.

Bellanger, L., Husi, P. & Tomassone, R. (2006). Statistical Aspects of
Pottery Quantification for the Dating of Some Archaeological Contexts.
\emph{Archaeometry}, 48(1), 169-183. \doi{10.1111/j.1475-4754.2006.00249.x}.
}
\seealso{
Other event date tools: 
\code{\link{density_event}()},
\code{\link{event}()},
\code{\link{model_event}},
\code{\link{plot_event}},
\code{\link{resample_event}}
}
\author{
N. Frerebeau
}
\concept{event date tools}
