% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_header_above.R
\name{add_header_above}
\alias{add_header_above}
\title{Add a header row on top of current header}
\usage{
add_header_above(kable_input, header = NULL, bold = FALSE, italic = FALSE,
  monospace = FALSE, escape = TRUE)
}
\arguments{
\item{kable_input}{Output of \code{knitr::kable()} with \code{format} specified}

\item{header}{A (named) character vector with \code{colspan} as values. For
example, \code{c(" " = 1, "title" = 2)} can be used to create a new header row
for a 3-column table with "title" spanning across column 2 and 3. For
convenience, when \code{colspan} equals to 1, users can drop the \code{= 1} part.
As a result, \code{c(" ", "title" = 2)} is the same as \code{c(" " = 1, "title" = 2)}.}

\item{bold}{A T/F value to control whether the text should be bolded.}

\item{italic}{A T/F value to control whether the text should to be emphasized.}

\item{monospace}{A T/F value to control whether the text of the selected column
need to be monospaced (verbatim)}

\item{escape}{A T/F value showing whether special characters should be
escaped.}
}
\description{
Tables with multiple rows of header rows are extremely useful
to demonstrate grouped data. This function takes the output of a \code{kable()}
function and adds an header row on top of it. This function can work with
both \code{HTML} and \code{LaTeX} outputs
}
\examples{
x <- knitr::kable(head(mtcars), "html")
# Add a row of header with 3 columns on the top of the table. The column
# span for the 2nd and 3rd one are 5 & 6.
add_header_above(x, c(" ", "Group 1" = 5, "Group 2" = 6))

}
