% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{kdglm}
\alias{kdglm}
\title{Fitting kDGLM models}
\usage{
kdglm(formula, ..., family, data = NULL, offset = NULL, p.monit = NA)
}
\arguments{
\item{formula}{an object of class "formula" (or one that can be coerced to that class): a symbolic description of the model to be fitted.}

\item{...}{Extra arguments, including extra formulas (multinomial case) or extra parameters (normal and gamma cases).}

\item{family}{a description of the error distribution to be used in the model. For kdglm this can be a character string naming a family function or a family function.}

\item{data}{an optional data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model. If not found in data, the variables are taken from environment(formula), typically the environment from which glm is called.}

\item{offset}{this can be used to specify an a priori known component to be included in the linear predictor during fitting. This should be NULL or a numeric vector of length equal to the number of cases. One or more offset terms can be included in the formula instead.}

\item{p.monit}{numeric (optional): The prior probability of changes in the latent space variables that are not part of its dynamic. Only used when performing sensitivity analysis.}
}
\value{
A fitted_dlm object.
}
\description{
Fit a model given its structure and the observed data. This function can be used for any supported family (see vignette).
}
\details{
This is the main function of the kDGLM package, as it is used to fit all models.

For the details about the implementation see  \insertCite{ArtigoPacote;textual}{kDGLM}.

For the details about the methodology see  \insertCite{ArtigokParametrico;textual}{kDGLM}.

For the details about the Dynamic Linear Models see  \insertCite{WestHarr-DLM;textual}{kDGLM} and \insertCite{Petris-DLM;textual}{kDGLM}.
}
\examples{

# Poisson case
fitted.data <- kdglm(c(AirPassengers) ~ pol(2) + har(12, order = 2), family = Poisson)
summary(fitted.data)
plot(fitted.data, plot.pkg = "base")

##################################################################

# Multinomial case
chickenPox$Total <- rowSums(chickenPox[, c(2, 3, 4, 6, 5)])
chickenPox$Vaccine <- chickenPox$date >= as.Date("2013-09-01")
fitted.data <- kdglm(`< 5 year` ~ pol(2, D = 0.95) + har(12, D = 0.975) + noise(R1 = 0.1) + Vaccine,
  `5 to 9 years` ~ pol(2, D = 0.95) + har(12, D = 0.975) + noise(R1 = 0.1) + Vaccine,
  `10 to 14 years` ~ pol(2, D = 0.95) + har(12, D = 0.975) + noise(R1 = 0.1) + Vaccine,
  `50 years or more` ~ pol(2, D = 0.95) + har(12, D = 0.975) + noise(R1 = 0.1) + Vaccine,
  N = chickenPox$Total,
  family = Multinom,
  data = chickenPox
)
summary(fitted.data)
plot(fitted.data, plot.pkg = "base")

##################################################################

# Univariate Normal case
fitted.data <- kdglm(corn.log.return ~ 1, V = ~1, family = Normal, data = cornWheat[1:500, ])
summary(fitted.data)
plot(fitted.data, plot.pkg = "base")

##################################################################

# Gamma case
Y <- (cornWheat$corn.log.return[1:500] - mean(cornWheat$corn.log.return[1:500]))**2
fitted.data <- kdglm(Y ~ 1, phi = 0.5, family = Gamma, data = cornWheat)
summary(fitted.data)
plot(fitted.data, plot.pkg = "base")

}
\seealso{
auxiliary functions for creating outcomes \code{\link{Poisson}}, \code{\link{Multinom}}, \code{\link{Normal}}, \code{\link{Gamma}}

auxiliary functions for creating structural blocks \code{\link{polynomial_block}}, \code{\link{regression_block}}, \code{\link{harmonic_block}}, \code{\link{TF_block}}

auxiliary functions for defining priors \code{\link{zero_sum_prior}}, \code{\link{CAR_prior}}

Other auxiliary functions for fitted_dlm objects: 
\code{\link{coef.fitted_dlm}()},
\code{\link{eval_dlm_norm_const}()},
\code{\link{fit_model}()},
\code{\link{forecast.fitted_dlm}()},
\code{\link{simulate.fitted_dlm}()},
\code{\link{smoothing}()},
\code{\link{update.fitted_dlm}()}
}
\concept{auxiliary functions for fitted_dlm objects}
