% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logical_to_binary.r
\name{two_cat_to_logical}
\alias{two_cat_to_logical}
\title{Take dataframe, and convert any columns with just two categories into logical}
\usage{
two_cat_to_logical(x, ignore_na = FALSE, na_val = FALSE)
}
\arguments{
\item{x}{input data frame}

\item{ignore_na}{logical}

\item{na_val}{Single value to use in place of \code{NA``, default is }FALSE`}
}
\value{
data frame with two categories columns replaced by logical columns
}
\description{
E.g. "Yes" would be converted to TRUE, "0" to FALSE, etc. If heuristics fail,
then the function stops with an error message. \code{NA} values are counted,
unless \code{ignore_na} is \code{TRUE}. When they are considered, \code{na_val}
indicates whether they are attributed \code{TRUE} or \code{FALSE}.
}
\examples{
df <- data.frame(
  a = c("y", "n", "y", "y", "n"),
  b = c(FALSE, TRUE, FALSE, TRUE, TRUE),
  c = c(NA, NA, NA, NA, NA),
  d = c(NA, "yes", NA, NA, "yes"),
  e = c("y ", "n ", NA, "y ", "n "),
  f = c("YES   ", "NO     ", "NO    ", " YES", " NO "),
  stringsAsFactors = FALSE
)
df
res <- two_cat_to_logical(df)
stopifnot(identical(res$a, c(TRUE, FALSE, TRUE, TRUE, FALSE)))
stopifnot(identical(res$b, c(FALSE, TRUE, FALSE, TRUE, TRUE)))
two_cat_to_logical(df, ignore_na = TRUE)
}
