% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df.r
\name{mergeBetter}
\alias{mergeBetter}
\title{merge better}
\usage{
mergeBetter(x, y, by.x, by.y, all.x = FALSE, all.y = FALSE, affix = NULL,
  renameConflict = c("suffix", "prefix"), renameAll = c("no", "suffix",
  "prefix"), convert_factors = TRUE, verbose = FALSE)
}
\arguments{
\item{x}{data frame}

\item{y}{data frame}

\item{by.x}{field in x to merge on. Unlike \code{merge}, this is compulsory.}

\item{by.y}{field in y to merge on. Unlike \code{merge}, this is compulsory.}

\item{all.x}{outer join to keep all x values}

\item{all.y}{outer join to keep all y values}

\item{affix}{either prefix or suffix to disambiguate files. By default, this
is the name of the table specified in \code{y}. In all other respects in
this function, \code{x} and \code{y} are symmetric.}

\item{renameConflict}{- determines whether prefix or suffix is added to
disambiguate conflicting column names. Value can be "suffix", "prefix".
Suffix is the default.}

\item{renameAll}{- regardless of column name clashes, "prefix" or "suffix"
with every field with original table name, or "no" for neither}

\item{convert_factors}{Default is TRUE which causes factors to be converted
to character before merge. This is almost certainly safer.}

\item{verbose}{logical or numbers 0, 1 or 2. 1 or TRUE will give moderate
verbosity, 2 will give full verbosity. 0 or FALSE turns off all messages.}
}
\value{
merged data frame
}
\description{
apply built-in R merge but with additional features:
}

