% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jubilee-macro-fit-method.R
\name{jubilee.macro_fit}
\alias{jubilee.macro_fit}
\title{The GUPTY macro model}
\usage{
jubilee.macro_fit(dtb, N, K, unrate.frac.start, gdp.frac.start, frac.end,
  cv.frac.end)
}
\arguments{
\item{dtb}{data table, usually this is the reg.dtb of the jubilee object}

\item{N}{numeric, number of years for GDP log-return calculation in GDP models}

\item{K}{numeric, number of years for GDP log-return calculation in Payroll and TCU models}

\item{unrate.frac.start}{numeric, starting fraction of unrate regression time period}

\item{gdp.frac.start}{numeric, starting fraction of gdp regression time period}

\item{frac.end}{numeric, ending fraction of regression time period.
This is also the starting fraction of cross-validation.}

\item{cv.frac.end}{numeric, ending fraction of cross-validation time period.
Cross validation can be disabled by setting it to NA.}
}
\value{
The list of data elements and their attributes.
}
\description{
This utility contains the macro regression models, covering GUPTY: three types of GDP,
UNRATE (unemployment rate), Payroll, and Treasury yield curve.
TCU (total capacity utilization) is also covered in the model but less recommended.
Given the in-sample time periods, it will perform model regressions
and return a list storing relavant information about the result. 
The purpose of this method is to automate the regression and facilitate
programatic cross validation.
}
\examples{
\dontrun{
  repo <- jubilee.repo()
  ju <- jubilee(repo@ie, 45, 20)
  N <- 4
  K <- 1.5
  rs <- jubilee.macro_fit(ju@reg.dtb, N, K, 1950, 1960, 2010, 2019)
}
}
\references{
Stephen H.T. Lihn, "Business Cycles, Optimal Interest Rate,
    and Recession Forecast From Yield Curve, Unemployment, GDP, and Payrolls."
    Available at SSRN: \url{https://ssrn.com/abstract=3422278}
}
\author{
Stephen H. Lihn
}
\keyword{data}
