% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summ.R
\name{set_summ_defaults}
\alias{set_summ_defaults}
\title{Set defaults for \code{summ()} functions}
\usage{
set_summ_defaults(
  digits = NULL,
  model.info = NULL,
  model.fit = NULL,
  pvals = NULL,
  robust = NULL,
  confint = NULL,
  ci.width = NULL,
  vifs = NULL,
  conf.method = NULL,
  table.format = NULL
)
}
\arguments{
\item{digits}{An integer specifying the number of digits past the decimal to
report in the output. Default is 2. You can change the default number of
digits for all jtools functions with
\code{options("jtools-digits" = digits)} where digits is the desired
number.}

\item{model.info}{Toggles printing of basic information on sample size,
name of DV, and number of predictors.}

\item{model.fit}{Toggles printing of model fit statistics.}

\item{pvals}{Show p values? If \code{FALSE}, these
are not printed. Default is \code{TRUE}.}

\item{robust}{If not \code{FALSE}, reports heteroskedasticity-robust standard
errors instead of conventional SEs. These are also known as Huber-White
standard errors. There are several options provided by
\code{\link[sandwich:vcovHC]{sandwich::vcovHC()}}: \code{"HC0"}, \code{"HC1"}, \code{"HC2"}, \code{"HC3"}, \code{"HC4"},
\code{"HC4m"}, \code{"HC5"}.

Default is \code{FALSE}.

This requires the \code{sandwich} package to compute the
standard errors.}

\item{confint}{Show confidence intervals instead of standard errors? Default
is \code{FALSE}.}

\item{ci.width}{A number between 0 and 1 that signifies the width of the
desired confidence interval. Default is \code{.95}, which corresponds
to a 95\% confidence interval. Ignored if \code{confint = FALSE}.}

\item{vifs}{If \code{TRUE}, adds a column to output with variance inflation
factors (VIF). Default is \code{FALSE}.}

\item{conf.method}{Argument passed to \code{\link[lme4:confint.merMod]{lme4::confint.merMod()}}. Default
is \code{"Wald"}, but \code{"profile"} or \code{"boot"} are better when accuracy is a
priority. Be aware that both of the alternate methods are sometimes very
time-consuming.}

\item{table.format}{A format understood by \code{\link[=md_table]{md_table()}}}
}
\description{
This function is convenience wrapper for manually setting
options using \code{\link[=options]{options()}}. This gives a handy way to, for instance,
set the arguments to be used in every call to \code{\link[=summ]{summ()}} in your
script/session.

To make the settings persist across sessions, you can run this in your
\code{.Rprofile} file.

Note that arguments that do not apply (e.g., \code{robust} for \code{merMod} models)
are silently ignored when those types of models are used.
}
