% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/center_lm.R
\name{center_lm}
\alias{center_lm}
\title{Center variables in fitted regression models}
\usage{
center_lm(model, binary.inputs = "0/1", center.response = FALSE)
}
\arguments{
\item{model}{A regression model of type \code{lm}, \code{glm}, or
\code{\link[survey]{svyglm}}. It should contain the interaction(s) of interest,
if any.}

\item{binary.inputs}{Options for binary variables. Default is \code{0/1};
\code{0/1} keeps original scale; \code{-0.5,0.5} rescales 0 as -0.5 and 1 as 0.5;
\code{center} subtracts the mean; and \code{full} treats them like other
continuous variables.}

\item{center.response}{Should the response variable also be centered? Default
is \code{FALSE}.}
}
\value{
The functions returns a \code{lm} or \code{glm} object, inheriting from
  whichever class was supplied.
}
\description{
\code{center_lm()} takes fitted regression models and mean-centers the continuous
  variables in the model to aid interpretation, especially in the case of models
  with interactions.
}
\details{
This function will mean-center all continuous variables in a regression
  model for ease of interpretation, especially for those models that have
  interaction terms. The mean for \code{svyglm} objects is calculated using
  \code{svymean}, so reflects the survey-weighted mean. The weight variables
  in \code{svyglm} are not centered, nor are they in other \code{lm} family
  models.

  This function re-estimates the model, so for large models one should expect
  a runtime equal to the first run.
}
\examples{

fit <- lm(formula = Murder ~ Income * Illiteracy, data = as.data.frame(state.x77))
fit_center <- center_lm(fit)

# With weights
fitw <- lm(formula = Murder ~ Income * Illiteracy,
           data = as.data.frame(state.x77),
           weights = Population)
fitw_center <- center_lm(fitw)

# With svyglm
library(survey)
data(api)
dstrat <- svydesign(id=~1,strata=~stype, weights=~pw, data=apistrat, fpc=~fpc)
regmodel <- svyglm(api00~ell*meals,design=dstrat)
regmodel_center <- center_lm(regmodel)

}
\references{
Bauer, D. J., & Curran, P. J. (2005). Probing interactions in fixed and multilevel
 regression: Inferential and graphical techniques. \emph{Multivariate Behavioral
 Research}, \emph{40}(3), 373-400.

Cohen, J., Cohen, P., West, S. G., & Aiken, L. S. (2003). \emph{Applied multiple
regression/correlation analyses for the behavioral sciences} (3rd ed.).
Mahwah, NJ: Lawrence Erlbaum Associates, Inc.
}
\seealso{
\code{\link{sim_slopes}} performs a simple slopes analysis.

  \code{\link{interact_plot}} creates attractive, user-configurable plots of
  interaction models.

Other standardization, scaling, and centering tools: \code{\link{gscale}},
  \code{\link{scale_lm}}
}
\author{
Jacob Long <\email{long.1377@osu.edu}>
}
