% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{jstor_import}
\alias{jstor_import}
\title{Wrapper for file import}
\usage{
jstor_import(in_paths, out_file, out_path = NULL, .f, col_names = TRUE,
  n_batches = NULL, files_per_batch = NULL, cores = getOption("mc.cores",
  1L), show_progress = TRUE)
}
\arguments{
\item{in_paths}{A character vector to the \code{xml}-files which should be
imported}

\item{out_file}{Name of files to export to. Each batch gets appended by an
increasing number.}

\item{out_path}{Path to export files to (combined with filename).}

\item{.f}{Function to use for import. Can be one of \code{find_article},
\code{find_authors}, \code{find_references}, \code{find_footnotes}, \code{find_book} or
\code{find_chapter}.}

\item{col_names}{Should column names be written to file? Defaults to \code{TRUE}.}

\item{n_batches}{Number of batches, defaults to 1.}

\item{files_per_batch}{Number of files for each batch. Can be used instead of
n_batches, but not in conjunction.}

\item{cores}{Number of cores to use for parallel processing.}

\item{show_progress}{Displays a progress bar for each batch, if the session
is interactive.}
}
\value{
Writes \code{.csv}-files to disk.
}
\description{
This function applies an import function to a list of \code{xml}-files
or a .zip-archive in case of \code{jstor_import_zip} and saves
the output in batches of \code{.csv}-files to disk.
}
\details{
Along the way, we wrap three functions, which make the process of converting
many files easier:
\itemize{
\item \code{\link[purrr:safely]{purrr::safely()}}
\item \code{\link[foreach:foreach]{foreach::foreach()}}
\item \code{\link[readr:write_csv]{readr::write_csv()}}
}

When using one of the \code{find_*} functions, there should usually be no errors.
To avoid the whole computation to fail in the unlikely event that an error
occurs, we use \code{safely()} which let's us
continue the process, and catch the error along the way.

If you have many files to import, you might benefit from executing the
function in parallel. We use
\code{\link[snow:snow-startstop]{snow::createCluster()}} to setup a cluster
and
then compute the results via \code{foreach} and \code{\%dopar\%}. The type of
cluster is determined by \code{getClusterOption("type")}.

After importing all files, they are written to disk with
\code{\link[readr:write_csv]{readr::write_csv()}}.

Since you might run out of memory when importing a large quantity of files,
the files to import are split up into batches. Each batch is being treated
separately, therefore for each batch multiple processes from
\code{\link[snow:snow-startstop]{snow::createCluster()}} are
spawned. For this reason, it is not recommended to have very small batches,
as there is an overhead for starting and ending the processes. On the other
hand, the batches should not be too large, to not exceed memory limitations.
A value of 10000 to 20000 for \code{files_per_batch} should work fine on most
machines. If the session is interactive and \code{show_progress} is \code{TRUE}, a
progress bar is displayed for each batch.
}
\examples{
\dontrun{
# read from file list --------
# find all files
meta_files <- list.files(pattern = "xml", full.names = T)

# import them via `find_article`
jstor_import(meta_files, out_file = "imported_metadata", .f = find_article,
             files_per_batch = 25000, cores = 4)

# read from zip archive ------ 
# define imports
imports <- jst_define_import(article = c(find_article, find_authors))

# convert the files to .csv
jstor_import_zip("my_archive.zip", out_file = "my_out_file", 
                 import_spec = imports)
} 
}
\seealso{
\code{\link[=jst_combine_outputs]{jst_combine_outputs()}}
}
