% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_jstage_volumes.R
\name{get_jstage_volumes}
\alias{get_jstage_volumes}
\title{Get J-Stage Volumes and Issues List}
\usage{
get_jstage_volumes(
  pubyearfrom = NA,
  pubyearto = NA,
  material = "",
  issn = "",
  cdjournal = "",
  volorder = NA,
  lang = "ja"
)
}
\arguments{
\item{pubyearfrom}{An integer specifying the starting publication year (in YYYY format).}

\item{pubyearto}{An integer specifying the ending publication year (in YYYY format).}

\item{material}{A character string specifying the material name (exact match search).}

\item{issn}{A character string specifying the ISSN (exact match search in XXXX-XXXX
format).}

\item{cdjournal}{A character string specifying the journal code.}

\item{volorder}{An integer specifying the order of volumes: 1 for ascending, 2 for
descending (default is 1).}

\item{lang}{A character string specifying the language for column names: "ja" for
Japanese (default is "ja").}
}
\value{
A list containing metadata and entry data frames with the search
results.
}
\description{
Retrieves a list of volumes and issues published on J-STAGE.
}
