% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestglm.R
\name{forestglmUI}
\alias{forestglmUI}
\title{forestglmUI:Shiny module UI for forestglm}
\usage{
forestglmUI(id, label = "forestplot")
}
\arguments{
\item{id}{id}

\item{label}{label, Default: 'forestplot'}
}
\value{
Shinymodule UI
}
\description{
Shiny module UI for forestcox
}
\details{
Shinymodule UI for forestglm
}
\examples{
library(shiny)
library(DT)
mtcars$vs <- factor(mtcars$vs)
mtcars$am <- factor(mtcars$am)
mtcars$kk <- factor(as.integer(mtcars$disp >= 150))
mtcars$kk1 <- factor(as.integer(mtcars$disp >= 200))

ui <- fluidPage(
  sidebarLayout(
    sidebarPanel(
      forestglmUI("Forest")
    ),
    mainPanel(
      tabsetPanel(
        type = "pills",
        tabPanel(
          title = "Data",
          DTOutput("tablesub"),
        ),
        tabPanel(
          title = "figure",
          plotOutput("forestplot", width = "100\%"),
          ggplotdownUI("Forest")
        )
      )
    )
  )
)

out <- mtcars

server <- function(input, output, session) {
  data <- reactive(out)
  label <- reactive(jstable::mk.lev(out))
  outtable <- forestglmServer("Forest", data = data, data_label = label, family = "binomial")
  output$tablesub <- renderDT({
    outtable()[[1]]
  })
  output$forestplot <- renderPlot({
    outtable()[[2]]
  })
}

}
