% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestcox.R
\name{forestcoxUI}
\alias{forestcoxUI}
\title{forestcoxUI:shiny module UI for forestcox}
\usage{
forestcoxUI(id, label = "forestplot")
}
\arguments{
\item{id}{id}

\item{label}{label, Default: 'forestplot'}
}
\value{
Shinymodule UI
}
\description{
Shiny module UI for forestcox
}
\details{
Shinymodule UI for forestcox
}
\examples{

library(shiny);library(DT);

mtcars$vs<-factor(mtcars$vs)
mtcars$am<-factor(mtcars$am)
mtcars$kk<-factor(as.integer(mtcars$disp>= 150))
mtcars$kk1<-factor(as.integer(mtcars$disp >= 200))

out<-mtcars
ui <- fluidPage(
  sidebarLayout(
    sidebarPanel(
      forestcoxUI('Forest')
    ),
    mainPanel(
      DTOutput('tablesub')
    )
  )
)


server <- function(input, output, session) {
  data<-reactive(out)
 label<-reactive(jstable::mk.lev(out))
 outtable<-forestcoxServer('Forest',data=data,data_label=label)
  output$tablesub<-renderDT({
    outtable()
  })
}


}
