% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructors.R
\name{build}
\alias{build}
\alias{build_array}
\alias{build_array_}
\alias{build_object}
\alias{build_object_}
\title{Build arrays and objects}
\usage{
build_array(.data, ...)

build_array_(.data, ..., .dots)

build_object(.data, ...)

build_object_(.data, ..., .dots)
}
\arguments{
\item{.data}{input. This can be JSON input, or an object of class
\code{jqr} that has JSON and query params combined, which is passed
from function to function when using the jqr DSL.}

\item{...}{Comma separated list of unquoted variable names}

\item{.dots}{Used to work around non-standard evaluation}

\item{dots}{dots}
}
\description{
Build arrays and objects
}
\examples{
## BUILD ARRAYS
x <- '{"user":"jqlang", "projects": ["jq", "wikiflow"]}' 
jq(x, "[.user, .projects[]]")
x \%>\% build_array(.user, .projects[])

jq('[1, 2, 3]', '[ .[] | . * 2]')
'[1, 2, 3]' \%>\% build_array(.[] | . * 2)


## BUILD OBJECTS
'{"foo": 5, "bar": 7}' \%>\% build_object(a = .foo) \%>\% peek
'{"foo": 5, "bar": 7}' \%>\% build_object(a = .foo)

# using json dataset, just first element
x <- commits \%>\% index(0)
x \%>\%
   build_object(message = .commit.message, name = .commit.committer.name)
x \%>\% build_object(sha = .commit.tree.sha, author = .author.login)

# using json dataset, all elements
x <- index(commits)
x \%>\% build_object(message = .commit.message, name = .commit.committer.name)
x \%>\% build_object(sha = .sha, name = .commit.committer.name)

# many JSON inputs
'{"foo": 5, "bar": 7} {"foo": 50, "bar": 7} {"foo": 500, "bar": 7}' \%>\%
  build_object(hello = .foo)
}
