% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joyn_workhorse.R
\name{joyn_workhorse}
\alias{joyn_workhorse}
\title{Internal workhorse join function, used in the backend of \code{joyn}}
\usage{
joyn_workhorse(
  x,
  y,
  by = intersect(names(x), names(y)),
  match_type = c("1:1"),
  suffixes = getOption("joyn.suffixes")
)
}
\arguments{
\item{x}{data object, "left" or "master"}

\item{y}{data object, "right" or "using"}

\item{by}{atomic character vector: key specifying join}

\item{match_type}{atomic character vector of length 1: either "1:1" (default)
"1:m", "m:1", or "m:m". If "m:m" then executes \code{data.table::merge.data.table}
in the backend, otherwise uses \code{collapse::join()}}

\item{suffixes}{atomic character vector: give suffixes to columns common to both
\code{x} and \code{y}}
}
\value{
data object of same class as \code{x}
}
\description{
Always executes a full join.
}
\examples{
\dontrun{
# Full join
library(data.table)
x1 = data.table(id = c(1L, 1L, 2L, 3L, NA_integer_),
                t  = c(1L, 2L, 1L, 2L, NA_integer_),
                x  = 11:15)
y1 = data.table(id = c(1,2, 4),
                y  = c(11L, 15L, 16))
joyn:::joyn_workhorse(x = x1, y=y1)
}
}
\keyword{internal}
