% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_tib2bib.R
\name{write_tib2bib}
\alias{write_tib2bib}
\title{Export a BibTeX \code{tibble} to a .bib file.}
\usage{
write_tib2bib(
  tib,
  file = tempfile(fileext = ".bib"),
  append = FALSE,
  isformat = TRUE,
  connect_author = c("nothing", "\\\\\\\\&", "&", "and")
)
}
\arguments{
\item{tib}{\code{tibble}, in the format as returned by \code{\link{read_bib2tib}}.}

\item{file}{character, file path to write the .bib file.}

\item{append}{logical, if \code{TRUE} the \code{tibble} will be appended to an existing file.}

\item{isformat}{logical, if \code{TRUE} the  Fields in \code{tibble} will complete braces to make them appear in pairs.}

\item{connect_author}{character, what symbols are used to connect multiple authors, \code{'nothing','\\\\&', '&', 'and'}, where \code{'nothing'} stand for do nothing(default).}
}
\value{
\code{file} as a character string, invisibly.
}
\description{
The BibTeX \code{tibble} is written to a .bib file.
}
\examples{
# Read from .bib file:
}
