% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.jointdata.R
\name{sample.jointdata}
\alias{sample.jointdata}
\title{Sample from a \code{jointdata} x}
\usage{
sample.jointdata(x, size, replace = FALSE)
}
\arguments{
\item{x}{an object of class \code{jointdata}.}

\item{size}{number of subjects to include in the sampled subset.}

\item{replace}{should sampling be with replacement? Default is \code{replace
= TRUE}.}
}
\value{
An object of class \code{jointdata}, with data only on the subjects 
  sampled.
}
\description{
Generic function used to sampling a subset of data from an x of
  class \code{jointdata}, with a specific size of number of subjects.
}
\examples{
data(heart.valve)
heart.surv <- UniqueVariables(heart.valve, 
                              var.col = c("fuyrs", "status"), 
                              id.col = "num")
heart.valve.jd <- jointdata(survival = heart.surv, 
                            id.col = "num", 
                            time.col = "time")
sample.jointdata(heart.valve.jd, size = 10)
}
\seealso{
\code{\link{sample}}, \code{\link{jointdata}}, 
  \code{\link{UniqueVariables}}.
}
\author{
Ines Sousa (\email{isousa@math.uminho.pt})
}
\keyword{data}
