% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bfi_sample3}
\alias{bfi_sample3}
\title{Twenty-five personality self-report items taken from the International Personality Item Pool
(testing file for ordered factors / "Ordinal"-variables in jamovi)}
\format{
A data.frame with 250 rows and 28 variables
\describe{
\item{ID}{integer}{Respondent ID}
\item{A1}{ordered factor}{Am indifferent to the feelings of others. (reversed)}
\item{A2}{ordered factor}{Inquire about others' well-being.}
\item{A3}{ordered factor}{Know how to comfort others.}
\item{A4}{ordered factor}{Love children.}
\item{A5}{ordered factor}{Make people feel at ease.}
\item{C1}{ordered factor}{Am exacting in my work.}
\item{C2}{ordered factor}{Continue until everything is perfect.}
\item{C3}{ordered factor}{Do things according to a plan.}
\item{C4}{ordered factor}{Do things in a half-way manner. (reversed)}
\item{C5}{ordered factor}{Waste my time. (reversed)}
\item{E1}{ordered factor}{Don't talk a lot. (reversed)}
\item{E2}{ordered factor}{Find it difficult to approach others. (reversed)}
\item{E3}{ordered factor}{Know how to captivate people.}
\item{E4}{ordered factor}{Make friends easily.}
\item{E5}{ordered factor}{Take charge.}
\item{N1}{ordered factor}{Get angry easily.}
\item{N2}{ordered factor}{Get irritated easily.}
\item{N3}{ordered factor}{Have frequent mood swings.}
\item{N4}{ordered factor}{Often feel blue.}
\item{N5}{ordered factor}{Panic easily.}
\item{O1}{ordered factor}{Am full of ideas.}
\item{O2}{ordered factor}{Avoid difficult reading material. (reversed)}
\item{O3}{ordered factor}{Carry the conversation to a higher level.}
\item{O4}{ordered factor}{Spend time reflecting on things.}
\item{O5}{ordered factor}{Will not probe deeply into a subject. (reversed)}
\item{gender}{factor}{Gender of the respondent (Females, Males)}
\item{age}{integer}{Age of the respondent (years)}
}
}
\usage{
bfi_sample3
}
\description{
The data set contains responses from 250 participants filling in twenty-five personality self-report items
taken from the International Personality Item Pool (https://ipip.ori.org) as part of the Synthetic Aperture
Personality Assessment (SAPA) web-based personality assessment (https://sapa-project.org) project.
The 25 items are organized by five putative factors: Agreeableness (A1 to A5), Conscientiousness (C1 to C5),
Extraversion (E1 to E5), Neuroticism (N1 to N5), and Openness (N1 to N5). The items were short phrases that
the respondent should answer by indicating how accurately the statement describes their typical behaviour or
attitude. Responses were collected using a 6-point scale: 1 - Very inaccurate, 2 - Moderately inaccurate,
3 - Slightly inaccurate, 4 - Slightly accurate, 5 - Moderately accurate, 6 - Very accurate.
The data set includes the jamovi-attributes. It is supposed to result in an identical file compared to the
bfi_sample2.omv-file contained in the extdata-directory of the package when written with write_omv.
}
\keyword{datasets}
