
# This file is automatically generated, you probably don't want to edit this

anovaOptions <- if (requireNamespace('jmvcore')) R6::R6Class(
    "anovaOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            dep = NULL,
            factors = NULL,
            modelTerms = NULL,
            ss = "3",
            effectSize = NULL,
            contrasts = NULL,
            plotHAxis = NULL,
            plotSepLines = NULL,
            plotSepPlots = NULL,
            postHoc = NULL,
            postHocCorr = list(
                "tukey"),
            descStats = FALSE,
            homo = FALSE,
            qq = FALSE,
            plotError = "ci",
            ciWidth = 95, ...) {

            super$initialize(
                package='jmv',
                name='anova',
                requiresData=TRUE,
                ...)

            private$..dep <- jmvcore::OptionVariable$new(
                "dep",
                dep,
                required=TRUE,
                suggested=list(
                    "continuous"),
                permitted=list(
                    "numeric"))
            private$..factors <- jmvcore::OptionVariables$new(
                "factors",
                factors,
                required=TRUE,
                rejectUnusedLevels=TRUE,
                suggested=list(
                    "nominal",
                    "ordinal"),
                permitted=list(
                    "factor"),
                default=NULL)
            private$..modelTerms <- jmvcore::OptionTerms$new(
                "modelTerms",
                modelTerms,
                default=NULL)
            private$..ss <- jmvcore::OptionList$new(
                "ss",
                ss,
                options=list(
                    "1",
                    "2",
                    "3"),
                default="3")
            private$..effectSize <- jmvcore::OptionNMXList$new(
                "effectSize",
                effectSize,
                options=list(
                    "eta",
                    "partEta",
                    "omega"),
                default=NULL)
            private$..contrasts <- jmvcore::OptionArray$new(
                "contrasts",
                contrasts,
                items="(factors)",
                default=NULL,
                template=jmvcore::OptionGroup$new(
                    "contrasts",
                    NULL,
                    elements=list(
                        jmvcore::OptionVariable$new(
                            "var",
                            NULL,
                            content="$key"),
                        jmvcore::OptionList$new(
                            "type",
                            NULL,
                            options=list(
                                "none",
                                "deviation",
                                "simple",
                                "difference",
                                "helmert",
                                "repeated",
                                "polynomial")))))
            private$..plotHAxis <- jmvcore::OptionVariable$new(
                "plotHAxis",
                plotHAxis,
                default=NULL)
            private$..plotSepLines <- jmvcore::OptionVariable$new(
                "plotSepLines",
                plotSepLines,
                default=NULL)
            private$..plotSepPlots <- jmvcore::OptionVariable$new(
                "plotSepPlots",
                plotSepPlots,
                default=NULL)
            private$..postHoc <- jmvcore::OptionTerms$new(
                "postHoc",
                postHoc,
                default=NULL)
            private$..postHocCorr <- jmvcore::OptionNMXList$new(
                "postHocCorr",
                postHocCorr,
                options=list(
                    "none",
                    "tukey",
                    "scheffe",
                    "bonf",
                    "holm"),
                default=list(
                    "tukey"))
            private$..descStats <- jmvcore::OptionBool$new(
                "descStats",
                descStats,
                default=FALSE)
            private$..homo <- jmvcore::OptionBool$new(
                "homo",
                homo,
                default=FALSE)
            private$..qq <- jmvcore::OptionBool$new(
                "qq",
                qq,
                default=FALSE)
            private$..plotError <- jmvcore::OptionList$new(
                "plotError",
                plotError,
                options=list(
                    "none",
                    "ci",
                    "se"),
                default="ci")
            private$..ciWidth <- jmvcore::OptionNumber$new(
                "ciWidth",
                ciWidth,
                min=50,
                max=99.9,
                default=95)

            self$.addOption(private$..dep)
            self$.addOption(private$..factors)
            self$.addOption(private$..modelTerms)
            self$.addOption(private$..ss)
            self$.addOption(private$..effectSize)
            self$.addOption(private$..contrasts)
            self$.addOption(private$..plotHAxis)
            self$.addOption(private$..plotSepLines)
            self$.addOption(private$..plotSepPlots)
            self$.addOption(private$..postHoc)
            self$.addOption(private$..postHocCorr)
            self$.addOption(private$..descStats)
            self$.addOption(private$..homo)
            self$.addOption(private$..qq)
            self$.addOption(private$..plotError)
            self$.addOption(private$..ciWidth)
        }),
    active = list(
        dep = function() private$..dep$value,
        factors = function() private$..factors$value,
        modelTerms = function() private$..modelTerms$value,
        ss = function() private$..ss$value,
        effectSize = function() private$..effectSize$value,
        contrasts = function() private$..contrasts$value,
        plotHAxis = function() private$..plotHAxis$value,
        plotSepLines = function() private$..plotSepLines$value,
        plotSepPlots = function() private$..plotSepPlots$value,
        postHoc = function() private$..postHoc$value,
        postHocCorr = function() private$..postHocCorr$value,
        descStats = function() private$..descStats$value,
        homo = function() private$..homo$value,
        qq = function() private$..qq$value,
        plotError = function() private$..plotError$value,
        ciWidth = function() private$..ciWidth$value),
    private = list(
        ..dep = NA,
        ..factors = NA,
        ..modelTerms = NA,
        ..ss = NA,
        ..effectSize = NA,
        ..contrasts = NA,
        ..plotHAxis = NA,
        ..plotSepLines = NA,
        ..plotSepPlots = NA,
        ..postHoc = NA,
        ..postHocCorr = NA,
        ..descStats = NA,
        ..homo = NA,
        ..qq = NA,
        ..plotError = NA,
        ..ciWidth = NA)
)

anovaResults <- if (requireNamespace('jmvcore')) R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        main = function() private$.items[["main"]],
        model = function() private$..model,
        assump = function() private$.items[["assump"]],
        contrasts = function() private$.items[["contrasts"]],
        postHoc = function() private$.items[["postHoc"]],
        desc = function() private$.items[["desc"]],
        descPlot = function() private$.items[["descPlot"]],
        descPlots = function() private$.items[["descPlots"]]),
    private = list(
        ..model = NA),
    public=list(
        initialize=function(options) {
            super$initialize(
                options=options,
                name="",
                title="ANOVA")
            self$add(jmvcore::Table$new(
                options=options,
                name="main",
                title="ANOVA",
                columns=list()))
            private$..model <- NULL
            self$add(R6::R6Class(
                inherit = jmvcore::Group,
                active = list(
                    homo = function() private$.items[["homo"]],
                    qq = function() private$.items[["qq"]]),
                private = list(),
                public=list(
                    initialize=function(options) {
                        super$initialize(
                            options=options,
                            name="assump",
                            title="Assumption Checks")
                        self$add(jmvcore::Table$new(
                            options=options,
                            name="homo",
                            title="Test for Homogeneity of Variances (Levene's)",
                            columns=list()))
                        self$add(jmvcore::Image$new(
                            options=options,
                            name="qq",
                            title="Q-Q Plot"))}))$new(options=options))
            self$add(jmvcore::Array$new(
                options=options,
                name="contrasts",
                title="Contrasts",
                template=jmvcore::Table$new(
                    options=options,
                    title="Contrasts - $key",
                    columns=list())))
            self$add(jmvcore::Array$new(
                options=options,
                name="postHoc",
                title="Post Hoc Tests",
                template=jmvcore::Table$new(
                    options=options,
                    title="",
                    columns=list())))
            self$add(jmvcore::Table$new(
                options=options,
                name="desc",
                title="Descriptives",
                columns=list()))
            self$add(jmvcore::Image$new(
                options=options,
                name="descPlot",
                title="Descriptive Plot"))
            self$add(jmvcore::Array$new(
                options=options,
                name="descPlots",
                title="Descriptive Plots",
                template=jmvcore::Image$new(
                    options=options,
                    title="$key",
                    renderFun=".descPlot")))},
        .setModel=function(x) private$..model <- x))

anovaBase <- if (requireNamespace('jmvcore')) R6::R6Class(
    "anovaBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'jmv',
                name = 'anova',
                version = c(1,0,0),
                options = options,
                results = anovaResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = TRUE)
        }))

#' ANOVA
#'
#' Analysis of Variance
#'
#' @examples
#' data('ToothGrowth')
#'
#' anova(ToothGrowth, dep = 'len', factors = c('dose', 'supp'))
#'
#' #
#' #  ANOVA
#' #
#' #  ANOVA
#' #  -----------------------------------------------------------------------
#' #                 Sum of Squares    df    Mean Square    F        p
#' #  -----------------------------------------------------------------------
#' #    dose                   2426     2         1213.2    92.00    < .001
#' #    supp                    205     1          205.4    15.57    < .001
#' #    dose:supp               108     2           54.2     4.11     0.022
#' #    Residuals               712    54           13.2
#' #  -----------------------------------------------------------------------
#' #
#'
#' @param data the data as a data frame
#' @param dep a string naming the dependent variable from \code{data},
#'   variable must be numeric
#' @param factors a vector of strings naming the fixed factors from
#'   \code{data}
#' @param modelTerms a list of character vectors describing the terms to go
#'   into the model
#' @param ss \code{'1'}, \code{'2'} or \code{'3'} (default), the sum of
#'   squares to use
#' @param effectSize one or more of \code{'eta'}, \code{'partEta'}, or
#'   \code{'omega'}; use eta², partial eta², and omega² effect sizes,
#'   respectively
#' @param contrasts a list of lists specifying the factor and type of contrast
#'   to use, one of \code{'deviation'}, \code{'simple'}, \code{'difference'},
#'   \code{'helmert'}, \code{'repeated'} or \code{'polynomial'}
#' @param plotHAxis a string naming the variable placed on the horizontal axis
#'   of the plot
#' @param plotSepLines a string naming the variable represented as separate
#'   lines on the plot
#' @param plotSepPlots a string naming the variable to separate over to form
#'   multiple plots
#' @param postHoc a list of terms to perform post-hoc tests on
#' @param postHocCorr one or more of \code{'none'}, \code{'tukey'},
#'   \code{'scheffe'}, \code{'bonf'}, or \code{'holm'}; provide no, Tukey,
#'   Scheffe, Bonferroni, and Holm Post Hoc corrections respectively
#' @param descStats \code{TRUE} or \code{FALSE} (default), provide descriptive
#'   statistics
#' @param homo \code{TRUE} or \code{FALSE} (default), perform homogeneity
#'   tests
#' @param qq \code{TRUE} or \code{FALSE} (default), provide a Q-Q plot of
#'   residuals
#' @param plotError \code{'none'}, \code{'ci'} (default), or \code{'se'}. Use
#'   no error bars, use confidence intervals, or use standard errors on the
#'   plots, respectively
#' @param ciWidth a number between 50 and 99.9 (default: 95) specifying the
#'   confidence interval width
#' @return A results object containing:
#' \tabular{llllll}{
#'   \code{results$main} \tab \tab \tab \tab \tab a table of ANOVA results \cr
#'   \code{results$model} \tab \tab \tab \tab \tab The underlying \code{aov} object \cr
#'   \code{results$assump$homo} \tab \tab \tab \tab \tab a table of homogeneity tests \cr
#'   \code{results$assump$qq} \tab \tab \tab \tab \tab a q-q plot \cr
#'   \code{results$contrasts} \tab \tab \tab \tab \tab an array of contrasts tables \cr
#'   \code{results$postHoc} \tab \tab \tab \tab \tab an array of post-hoc tables \cr
#'   \code{results$desc} \tab \tab \tab \tab \tab a table of descriptive statistics \cr
#'   \code{results$descPlot} \tab \tab \tab \tab \tab a descriptives plot \cr
#'   \code{results$descPlots} \tab \tab \tab \tab \tab an array of descriptives plots \cr
#' }
#'
#' Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:
#'
#' \code{results$main$asDF}
#'
#' \code{as.data.frame(results$main)}
#'
#' @export
anova <- function(
    data,
    dep,
    factors = NULL,
    modelTerms = NULL,
    ss = "3",
    effectSize = NULL,
    contrasts = NULL,
    plotHAxis = NULL,
    plotSepLines = NULL,
    plotSepPlots = NULL,
    postHoc = NULL,
    postHocCorr = list(
                "tukey"),
    descStats = FALSE,
    homo = FALSE,
    qq = FALSE,
    plotError = "ci",
    ciWidth = 95) {

    if ( ! requireNamespace('jmvcore'))
        stop('anova requires jmvcore to be installed (restart may be required)')

    if (missing(data))
        data <- jmvcore:::marshalData(
            parent.frame(),
            `if`( ! missing(dep), dep, NULL),
            `if`( ! missing(factors), factors, NULL),
            `if`( ! missing(plotHAxis), plotHAxis, NULL),
            `if`( ! missing(plotSepLines), plotSepLines, NULL),
            `if`( ! missing(plotSepPlots), plotSepPlots, NULL))

    options <- anovaOptions$new(
        dep = dep,
        factors = factors,
        modelTerms = modelTerms,
        ss = ss,
        effectSize = effectSize,
        contrasts = contrasts,
        plotHAxis = plotHAxis,
        plotSepLines = plotSepLines,
        plotSepPlots = plotSepPlots,
        postHoc = postHoc,
        postHocCorr = postHocCorr,
        descStats = descStats,
        homo = homo,
        qq = qq,
        plotError = plotError,
        ciWidth = ciWidth)

    results <- anovaResults$new(
        options = options)

    analysis <- anovaClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}
