
# This file is automatically generated, you probably don't want to edit this

#' @importFrom jmvcore Options
#' @importFrom R6 R6Class
logLinearOptions <- R6::R6Class(
    "logLinearOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            counts = NULL,
            factors = NULL,
            modelTerms = NULL,
            est = FALSE,
            ci = FALSE,
            ciWidth = 95, ...) {

            super$initialize(
                package='jmv',
                name='logLinear',
                requiresData=TRUE,
                ...)
        
            private$..counts <- jmvcore::OptionVariable$new(
                "counts",
                counts,
                suggested=list(
                    "continuous"),
                permitted=list(
                    "continuous",
                    "nominal",
                    "ordinal"))
            private$..factors <- jmvcore::OptionVariables$new(
                "factors",
                factors,
                suggested=list(
                    "nominal",
                    "ordinal"),
                default=NULL)
            private$..modelTerms <- jmvcore::OptionTerms$new(
                "modelTerms",
                modelTerms,
                default=NULL)
            private$..est <- jmvcore::OptionBool$new(
                "est",
                est,
                default=FALSE)
            private$..ci <- jmvcore::OptionBool$new(
                "ci",
                ci,
                default=FALSE)
            private$..ciWidth <- jmvcore::OptionNumber$new(
                "ciWidth",
                ciWidth,
                min=50,
                max=99.9,
                default=95)
        
            self$.addOption(private$..counts)
            self$.addOption(private$..factors)
            self$.addOption(private$..modelTerms)
            self$.addOption(private$..est)
            self$.addOption(private$..ci)
            self$.addOption(private$..ciWidth)
        }),
    active = list(
        counts = function() private$..counts$value,
        factors = function() private$..factors$value,
        modelTerms = function() private$..modelTerms$value,
        est = function() private$..est$value,
        ci = function() private$..ci$value,
        ciWidth = function() private$..ciWidth$value),
    private = list(
        ..counts = NA,
        ..factors = NA,
        ..modelTerms = NA,
        ..est = NA,
        ..ci = NA,
        ..ciWidth = NA)
)

#' @import jmvcore
#' @importFrom R6 R6Class
logLinearResults <- R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        table = function() private$..table),
    private = list(
        ..table = NA),
    public=list(
        initialize=function(options) {
            super$initialize(options=options, name="", title="Log-Linear Regression")
            private$..table <- jmvcore::Table$new(
                options=options,
                name="table",
                title="Log-Linear Regression",
                columns=list(
                    list(`name`="var", `title`="")))
            self$add(private$..table)}))

#' @importFrom jmvcore Analysis
#' @importFrom R6 R6Class
logLinearBase <- R6::R6Class(
    "logLinearBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'jmv',
                name = 'logLinear',
                version = c(1,0,0),
                options = options,
                results = logLinearResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL)
        }))

#' Log-Linear Regression
#'
#' 
#' @param data the data as a data frame
#' @param counts The counts 
#' @param factors The factors 
#' @param modelTerms The model terms 
#' @param est Estimates 
#' @param ci Confidence Intervals 
#' @param ciWidth .
#' @export
logLinear <- function(
    data,
    counts,
    factors = NULL,
    modelTerms = NULL,
    est = FALSE,
    ci = FALSE,
    ciWidth = 95) {

    options <- logLinearOptions$new(
        counts = counts,
        factors = factors,
        modelTerms = modelTerms,
        est = est,
        ci = ci,
        ciWidth = ciWidth)

    results <- logLinearResults$new(
        options = options)

    analysis <- logLinearClass$new(
        options = options,
        data = data)

    analysis$run()
    analysis$render()

    analysis
}
