% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot.R
\name{returngraph}
\alias{returngraph}
\title{return igraph object from jeek result specified by user input}
\usage{
returngraph(x, type = "task", neighbouroption = "task", subID = NULL,
  index = NULL)
}
\arguments{
\item{x}{output generated from jeek function (jeek class)}

\item{type}{type of graph, there are four options:
(1) "task" (graph for each task (including shared part) specified further by subID (task number))
(2) "share" (shared graph for all tasks)
(3) "taskspecific" (graph for each task specific (excluding shared part)
specified further by subID (task number) )
(4) "neighbour" (zoom into nodes in the graph specified further by neighbouroptoin, subID (task number)
and index (node id))}

\item{neighbouroption}{determines what type of graph to zoom into when parameter type is "neighbour"
There are two options:
(1) "task" (zoom into graph for each task (including shared part))
(2) "taskspecific" (zoom into graph for each task specific (excluding shared part))}

\item{subID}{selects which task to display
(1) 0 (only allowed when type is task or type is neighbour and neighbouroption is task) (selecting share graph)
(2) positive task number (selects a task number)
(3) a vector of task number (selects multiple tasks)
(4) NULL (selects all tasks (all graphs))}

\item{index}{determines which node(s) to zoom into when parameter type is "neighbour"
could either be an integer or vector of integers representing node ids
(zoom into one node or multiple nodes)}
}
\value{
an igraph object of graph / subgraph from jeek result specified by user input
}
\description{
This function can return an igraph object from jeek result for user to work with directly
}
\details{
the function aims to provide users the flexibility to explore and visualize the graph on their own
generated from jeek
}
\examples{
\dontrun{
data(exampleData)
result = jeek(X = exampleData, 0.3, covType = "cov", parallel = TRUE)
graph = returngraph(result)
}
}
\author{
Beilun Wang, Zhaoyang Wang (Author), Beilun Wang (maintainer)
}
