% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba.r
\name{unnestList}
\alias{unnestList}
\title{Un-nest a nested list into a simple list}
\usage{
unnestList(
  x,
  addNames = FALSE,
  unnamedBase = "x",
  parentName = NULL,
  sep = ".",
  makeNamesFunc = makeNames,
  stopClasses = c("dendrogram", "data.frame", "matrix", "package_version", "tbl",
    "data.table"),
  extraStopClasses = getOption("jam.stopClasses"),
  ...
)
}
\arguments{
\item{x}{\code{list} potentially containing nested lists.}

\item{addNames}{\code{logical} indicating whether to add names to
the list elements when names are not already present. When
\code{addNames=TRUE} and no names are present \code{unnamedBase} is
used to define names.}

\item{unnamedBase}{\code{character} value used as a base for naming any
un-named lists, using the format \code{makeNamesFunc(rep(unnamedBase, n))}.}

\item{parentName}{\code{character} with optional prefix, used as parent name,
default is NULL.}

\item{sep}{\code{character} delimiter used between nested list names.}

\item{makeNamesFunc}{\code{function} that takes a character vector and returns
non-duplicated character vector of equal length. By default it
uses \code{jamba::makeNames()}.}

\item{stopClasses}{\code{vector} of classes that should not be un-nested,
useful in case some classes inherit list properties.}

\item{extraStopClasses}{\code{vector} of additional values for \code{stopClasses},
created mostly to show that \code{options("jam.stopClasses")} can be
used to define \code{stopClasses}, for example when this function
is called but where arguments cannot be conveniently passed
through the calling function.}

\item{...}{additional arguments are ignored.}
}
\value{
\code{list} that has been flattened so that it contains
no \code{list} elements. Note that it may contain some list-like
objects such as \code{data.frame}, defined by \code{stopClasses}.
}
\description{
Un-nest a nested list into a simple list
}
\details{
This function inspects a list, and unlists each entry
resulting in a simple list of non-list entries as a result.
Sometimes when concatenating lists together, one list gets
added as a list-of-lists. This function resolves that problem
by providing one flat list.
}
\examples{
L <- list(A=letters[1:10],
   B=list(C=LETTERS[3:9], D=letters[4:11]),
   E=list(F=list(G=LETTERS[3:9], D=letters[4:11])));
L;

# inspect the data using str()
str(L);

unnestList(L);

# optionally change the delimiter
unnestList(L, sep="|");

# example with nested lists of data.frame objects
df1 <- data.frame(a=1:2, b=letters[3:4]);
DFL <- list(A=df1,
   B=list(C=df1, D=df1),
   E=list(F=list(G=df1, D=df1)));
str(DFL);
unnestList(DFL);
str(unnestList(DFL));

# packageVersion() returns class "package_version"
# where is.list(packageVersion("base")) is TRUE,
# but it cannot ever be subsetted as a list with x[[1]],
# and thus it breaks this function
identical(is.list(packageVersion("base")), is.list(packageVersion("base"))[[1]])
unnestList(lapply(nameVector(c("base","graphics")), packageVersion))

}
\seealso{
Other jam list functions: 
\code{\link{cPaste}()},
\code{\link{heads}()},
\code{\link{jam_rapply}()},
\code{\link{list2df}()},
\code{\link{mergeAllXY}()},
\code{\link{mixedSorts}()},
\code{\link{rbindList}()},
\code{\link{relist_named}()},
\code{\link{rlengths}()},
\code{\link{sclass}()},
\code{\link{sdim}()},
\code{\link{uniques}()}
}
\concept{jam list functions}
